/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileSimple;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.BitMap;

final class DataFileDefrag {
    RandomAccessInterface randomAccessOut;
    long fileOffset;
    StopWatch stopw = new StopWatch();
    String dataFileName;
    long[][] rootsList;
    Database database;
    DataFileCache dataCache;
    int scale;
    DoubleIntIndex pointerLookup;

    DataFileDefrag(Database database, DataFileCache dataFileCache, String string) {
        this.database = database;
        this.dataCache = dataFileCache;
        this.scale = dataFileCache.cacheFileScale;
        this.dataFileName = string;
    }

    void process() {
        Object object;
        Table table;
        int n;
        Throwable throwable = null;
        this.database.logger.logDetailEvent("Defrag process begins");
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables(true);
        this.rootsList = new long[hsqlArrayList.size()][];
        long l = 0L;
        int n2 = hsqlArrayList.size();
        for (n = 0; n < n2; ++n) {
            long l2;
            table = (Table)hsqlArrayList.get(n);
            if (table.getTableType() != 5 || (l2 = (long)(object = this.database.persistentStoreCollection.getStore(table)).elementCount()) <= l) continue;
            l = l2;
        }
        if (l > 0x3FFFFFFFL) {
            throw Error.error(3426);
        }
        try {
            this.pointerLookup = new DoubleIntIndex((int)l, false);
            this.randomAccessOut = this.database.logger.isStoredFileAccess() ? ScaledRAFile.newScaledRAFile(this.database, this.dataFileName + ".new", false, 3) : new ScaledRAFileSimple(this.database, this.dataFileName + ".new", "rw");
            this.randomAccessOut.write(new byte[this.dataCache.initialFreePos], 0, this.dataCache.initialFreePos);
            this.fileOffset = this.dataCache.initialFreePos;
            n2 = hsqlArrayList.size();
            for (n = 0; n < n2; ++n) {
                table = (Table)hsqlArrayList.get(n);
                if (table.getTableType() == 5) {
                    object = this.writeTableToDataFile(table);
                    this.rootsList[n] = (long[])object;
                    this.randomAccessOut.synch();
                } else {
                    this.rootsList[n] = null;
                }
                this.database.logger.logDetailEvent("table complete " + table.getName().name);
            }
            n = (int)(ArrayUtil.getBinaryNormalisedCeiling(this.fileOffset, 4096) - this.fileOffset);
            byte[] byArray = new byte[n];
            this.randomAccessOut.write(byArray, 0, n);
            this.randomAccessOut.seek(12L);
            this.randomAccessOut.writeLong(this.fileOffset);
            int n3 = 0;
            if (this.database.logger.propIncrementBackup) {
                n3 = BitMap.set(n3, 1);
            }
            n3 = BitMap.set(n3, 4);
            n3 = BitMap.set(n3, 2);
            this.randomAccessOut.seek(28L);
            this.randomAccessOut.writeInt(n3);
            this.randomAccessOut.synch();
            this.randomAccessOut.close();
            this.randomAccessOut = null;
            for (long[] lArray : this.rootsList) {
                if (lArray == null) continue;
                this.database.logger.logDetailEvent("roots: " + StringUtil.getList(lArray, ",", ""));
            }
        }
        catch (IOException iOException) {
            throwable = iOException;
            throw Error.error(452, iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throwable = outOfMemoryError;
            throw Error.error(460, outOfMemoryError);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw Error.error(458, throwable2);
        }
        finally {
            try {
                if (this.randomAccessOut != null) {
                    this.randomAccessOut.close();
                }
            }
            catch (Throwable throwable3) {}
            if (throwable instanceof OutOfMemoryError) {
                this.database.logger.logInfoEvent("defrag failed - out of memory - required: " + l * 8L);
            }
            if (throwable == null) {
                this.database.logger.logDetailEvent("Defrag transfer complete: " + this.stopw.elapsedTime());
            } else {
                this.database.logger.logSevereEvent("defrag failed ", throwable);
                this.database.logger.getFileAccess().removeElement(this.dataFileName + ".new");
            }
        }
    }

    void updateTableIndexRoots() {
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables(true);
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            if (table.getTableType() != 5) continue;
            long[] lArray = this.rootsList[i];
            table.setIndexRoots(lArray);
        }
    }

    long[] writeTableToDataFile(Table table) throws IOException {
        Row row;
        Session session = this.database.getSessionManager().getSysSession();
        PersistentStore persistentStore = table.getRowStore(session);
        RowOutputInterface rowOutputInterface = this.dataCache.rowOut.duplicate();
        long[] lArray = table.getIndexRootsArray();
        long l = this.fileOffset;
        long l2 = 0L;
        this.pointerLookup.removeAll();
        this.pointerLookup.setKeysSearchTarget();
        this.database.logger.logDetailEvent("lookup begins " + table.getName().name + " " + this.stopw.elapsedTime());
        RowIterator rowIterator = table.rowIteratorClustered(persistentStore);
        while (rowIterator.hasNext()) {
            row = rowIterator.getNextRow();
            this.pointerLookup.addUnsorted(row.getPos(), (int)(l / (long)this.scale));
            if (l2 != 0L && l2 % 100000L == 0L) {
                this.database.logger.logDetailEvent("pointer pair for row " + l2 + " " + row.getPos() + " " + l);
            }
            l += (long)row.getStorageSize();
            ++l2;
        }
        this.database.logger.logDetailEvent("table read " + table.getName().name + " " + this.stopw.elapsedTime());
        l2 = 0L;
        rowIterator = table.rowIteratorClustered(persistentStore);
        while (rowIterator.hasNext()) {
            row = rowIterator.getNextRow();
            rowOutputInterface.reset();
            row.write(rowOutputInterface, this.pointerLookup);
            this.randomAccessOut.write(rowOutputInterface.getOutputStream().getBuffer(), 0, rowOutputInterface.size());
            this.fileOffset += (long)row.getStorageSize();
            if (l2 != 0L && l2 % 100000L == 0L) {
                this.database.logger.logDetailEvent("rows count " + l2 + " " + this.stopw.elapsedTime());
            }
            ++l2;
        }
        for (int i = 0; i < table.getIndexCount(); ++i) {
            if (lArray[i] == -1L) continue;
            int n = this.pointerLookup.findFirstEqualKeyIndex((int)lArray[i]);
            if (n == -1) {
                throw Error.error(466);
            }
            lArray[i] = this.pointerLookup.getValue(n);
        }
        this.database.logger.logDetailEvent("table written " + table.getName().name);
        return lArray;
    }

    public long[][] getIndexRoots() {
        return this.rootsList;
    }

    static boolean checkAllTables(Database database) {
        Session session = database.getSessionManager().getSysSession();
        HsqlArrayList hsqlArrayList = database.schemaManager.getAllTables(true);
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            int n2 = 0;
            if (table.getTableType() != 5) continue;
            RowIterator rowIterator = table.rowIterator(session);
            while (rowIterator.hasNext()) {
                Row row = rowIterator.getNextRow();
                ++n2;
            }
            System.out.println("table " + table.getName().name + " " + n2);
        }
        return true;
    }
}

