(ns lcmap-cli.changedetection
  (:require [clojure.core.async :as async]
            [clojure.stacktrace :as st]
            [lcmap-cli.config :as cfg]
            [lcmap-cli.functions :as f]
            [lcmap-cli.http :as http]
            [lcmap-cli.state :as state]))

;;
;;TODO: move to http namespace
;; requires eliminating circular dep between http -> function ns's
;;
(defn errors?
  [r]
  (or (-> r f/try-deref :error some?)
      (-> r f/try-deref http/server-error?)))

(defn handler
  [{:keys [:response :cx :cy :grid :acquired :cutoff]}]

  (if (errors? response)
    {:cx cx
     :cy cy
     :acquired acquired
     :cutoff cutoff
     :error (-> response deref :error str)}
    ;; an error made it to this line below
    ;; find out why & fix it
    (-> response deref http/decode :body)))
      
(defn start-consumers
  [number retry-limit retry-delay in-chan out-chan]
  (dotimes [_ number]
    (async/thread
      (while (true?  @state/run-threads?)
        (let [func   (f/with-retry retry-limit retry-delay f/detect errors?)
              input  (async/<!! in-chan)
              result (handler (assoc input :response (func input)))]
          (async/>!! out-chan result))))))

(defn tile
  [{g :grid t :tile a :acquired c :cutoff :as all}]
  (let [config      ((keyword g) cfg/grids)
        chunk-size  (:segment-instance-count config)
        sleep-for   (:segment-sleep-for config)
        retry-delay (:segment-retry-delay config)
        retry-limit (:segment-retry-limit config)
        xys         (f/chips (assoc all :dataset "ard"))
        in-chan     (async/chan)
        out-chan    (async/chan)
        consumers   (start-consumers chunk-size retry-limit retry-delay in-chan out-chan)]
    
    (async/go (doseq [xy xys]
                (Thread/sleep sleep-for)
                (async/>! in-chan {:cx (:cx xy)
                                   :cy (:cy xy)
                                   :acquired a
                                   :cutoff c
                                   :grid g})))
    (dotimes [i (count xys)]
      (f/output (async/<!! out-chan))))
  
    all)
      
  
(defn chip
  [{:keys [:grid :cx :cy :acquired :cutoff] :as all}]
  (handler (assoc all :response (f/detect all))))
