(ns clojure.core.fix.locking
  (:import (clojure.core.fix Locking))
  (:refer-clojure :exclude [locking])
  (:gen-class))

(defmacro locking ;; patched version of clojure.core/locking to workaround GraalVM unbalanced monitor issue
  "Executes exprs in an implicit do, while holding the monitor of x.
   Will release the monitor of x in all circumstances."
  {:added "1.0"}
  [x & body]
  `(let [lockee# ~x]
     (Locking/lock lockee# (^{:once true} fn* [] ~@body))))
