(ns grafter.extra.repository
  (:require [grafter.rdf :refer [add statements]]
            [grafter.rdf.repository :refer [shutdown ->connection] :as grr]
            [grafter.tabular :refer [make-dataset]]))

(defmacro with-repository [repo-binding & body]
  `(let ~repo-binding
     (try
       ~@body
       (finally (shutdown (first ~repo-binding))))))

(defn load-contents [repository contents]
  (let [is-file? string?
        data (if (is-file? contents) (statements contents) contents)]
    (with-open [connection (->connection repository)]
      (add connection data))))

(defmacro with-repository-containing [[repo-binding repo-contents] & body]
  `(let [~repo-binding (grr/repo)]
     (try
       (load-contents ~repo-binding ~repo-contents)
       ~@body
       (finally (shutdown ~repo-binding)))))

(defn quick-query
  ([repository query]
   (quick-query repository query 10))
  
  ([repository query limit]
   (with-open [connection (->connection repository)]
     (let [prefixed-query (str (slurp "./test/resources/cube-prefixes.sparql")
                               query)
           results (doall (take limit (grr/query connection prefixed-query)))]
       (make-dataset results (-> results first keys))))))
