(ns tabular-functions.aggregations
  (
  :require
     [grafter.tabular :refer :all]
     [grafter.rdf :refer [s]]
     [grafter.rdf.protocols :refer [->Quad]]
     [grafter.rdf.templater :refer [graph]]
     [grafter.vocabularies.rdf :refer :all]
     [grafter.vocabularies.foaf :refer :all]
     [incanter.core :as inc]  ))

(defn MIN [& args] (apply min (map #(Double/parseDouble (str %)) args)))
(defn MAX [& args] (apply max (map #(Double/parseDouble (str %)) args)))
(defn SUM [& args] (apply + (map #(Double/parseDouble (str %)) args)))
(defn COUNT [& args] (count (into [] args)))
(defn AVG [& args] (/ (apply SUM args) (apply COUNT args)))
(defn COUNT-DISTINCT [& args] (count (distinct (into [] args))))
(defn median [& args] (let [sorted (sort args)
                            cnt (count sorted)
                            halfway (quot cnt 2)]
                        (println args)
                        ;(if (odd? cnt)
                          
                        ;  (nth sorted halfway) 
                        ;  (let [bottom (dec halfway)
                        ;        bottom-val (nth sorted bottom)
                        ;        top-val (nth sorted halfway)]
                        ;    (AVG bottom-val top-val)))
                        ))
(defn MEDIAN [& args] (println args
                       ;apply median (map #(Double/parseDouble (str %)) args)
                       ))
(defn MODE [& args] (let [numeric-args (map #(Double/parseDouble (str %)) args)
                          freqs (apply frequencies numeric-args)
                          occurrences (group-by val freqs)
                          modes (last (sort occurrences))
                          modes (->> modes
                                     val
                                     (map key))]
                     modes))
(defn STD-DEV [& args] (let [numeric-args (map #(Double/parseDouble (str %)) args)
                             avg (apply AVG numeric-args)
                             squares (for [x numeric-args]
                                        (let [x-avg (- x avg)]
                                          (* x-avg x-avg)))
                             total (apply count numeric-args)]
                           (-> (/ (apply + squares)
                                  (- total 1))
                               (Math/sqrt))))

(defn MERGE [separator & args] (clojure.string/join separator (distinct (into [] (map str args)))))
