(ns genesis.providers.aws.elb.target-group
  (:require [amazonica.aws.elasticloadbalancingv2 :as elb]
            [genesis.providers.aws.ec2 :as gec2]
            [clojure.set :as set]
            [clojure.spec.alpha :as s]
            [clojure.data :as data]
            [genesis.core :as g :refer [defresource]]
            [genesis.util :refer [validate!]]))

(s/def ::name string?)
(s/def ::port pos-int?)
(s/def ::protocol #{"HTTP" "HTTPS" "TCP"})
(s/def ::target-type #{"instance" "ip"})
(s/def ::vpc-id string?)

(s/def ::health-check-interval-seconds (s/int-in 5 301))
(s/def ::health-check-path string?)
(s/def ::health-check-port string?)
(s/def ::health-check-protocol #{"HTTP" "HTTPS" "TCP"})
(s/def ::health-check-timeout-seconds (s/int-in 2 61))
(s/def ::healthy-threshold-count (s/int-in 2 11))
(s/def ::unhealthy-threshold-count (s/int-in 2 11))

(s/def ::target-group (s/keys :req-un [::name
                                       ::port
                                       ::protocol
                                       ::vpc-id]
                              :opt-un [::health-check-interval-seconds
                                       ::health-check-path
                                       ::health-check-port
                                       ::health-check-protocol
                                       ::health-check-timeout-seconds
                                       ::healthy-threshold-count
                                       ::target-type
                                       ::unhealthy-threshold-count]))

(def create-target-group (gec2/create-with-identity elb/create-target-group {:spec ::target-group
                                                                             :id-key :target-group-arn
                                                                             :unwrap-array? true}))

(def list-target-groups (gec2/list-with-identity elb/describe-target-groups {:id-key :target-group-arn
                                                                             :require-args? true}))

(def get-target-group (gec2/get-by-identity list-target-groups))

(def delete-target-group (gec2/delete-by-identity {:get-fn get-target-group
                                                   :delete-fn elb/delete-target-group
                                                   :id-key :target-group-arn}))

(defresource :elb/target-group {:list list-target-groups
                                :get get-target-group
                                :create create-target-group
                                :delete delete-target-group})
