(ns genesis.specs
  (:require [clojure.spec.alpha :as s]))

(s/def :aws/creds (s/keys :req-un [:aws/access-key
                                   :aws/secret-key]
                          :opt-un [:aws/endpoint]))

(s/def ::aws (s/keys :req-un [:aws/creds]))

(s/def ::context (s/keys :req-un [::state]
                         :opt-un [::aws]))

(s/def ::resource qualified-keyword?)

(s/def ::identity string?)
(s/def ::name string?)

(s/def ::concrete-properties (s/coll-of any? :kind map?))
(s/def ::properties (s/or :m ::concrete-properties :thunk fn?))

(s/def ::key (s/tuple ::resource ::identity))
(s/def ::dependency ::key)
(s/def ::dependencies (s/coll-of ::dependency :kind set?))


(s/def ::instance- (s/keys :req-un [::resource]
                           :opt-un [::properties
                                    ::dependencies]))

(s/def ::config-instance (s/and ::instance- (s/keys :req-un [::name])))
(s/def ::existing-instance (s/and ::instance- (s/keys :req-un [::identity])))
(s/def ::managed-instance (s/and ::instance- (s/keys :req-un [::identity ::name])))

(s/def ::instance (s/or :ci ::config-instance :ei ::existing-instance))

(s/def ::instances (s/coll-of ::instance))
(s/def ::existing-instances (s/coll-of ::existing-instance))

(s/def ::configuration (s/coll-of ::config-instance))

(s/def :plan/action #{:create :update :delete})
(s/def ::plan-operation (s/keys :req-un [:plan/action :config/instance]))

(s/def ::plan (s/coll-of ::plan-operation))
