(ns genesis.providers.aws.acm.certificate
  (:require [amazonica.aws.certificatemanager :as acm]
            [genesis.providers.aws.ec2 :as gec2]
            [clojure.set :as set]
            [clojure.spec.alpha :as s]
            [clojure.data :as data]
            [genesis.core :as g :refer [defresource]]
            [genesis.util :refer [validate!]]))

(s/def ::domain-name string?)
(s/def ::validation-domain string?)

(s/def ::domain-validation-option (s/keys :req-un [::validation-domain
                                                   ::domain-name]))
(s/def ::domain-validation-options (s/coll-of ::domain-validation-option))
(s/def ::subject-alternative-names (s/coll-of string?))

(s/def ::certificate (s/keys :req-un [::domain-name]
                             :opt-un [::domain-validation-options
                                      ::subject-alternative-names]))

(def create-certificate (gec2/create-with-identity acm/request-certificate {:spec ::certificate
                                                                            :id-key :certificate-arn
                                                                            :unwrap? false}))

(def list-certificates (gec2/list-with-identity acm/list-certificates {:id-key :certificate-arn
                                                                       :require-args? true}))

(def get-certificate (gec2/get-by-identity list-certificates))

(def delete-certificate (gec2/delete-by-identity {:get-fn get-certificate
                                                  :delete-fn acm/delete-certificate
                                                  :id-key :certificate-arn}))

(defresource :acm/certificate {:create create-certificate
                               :list list-certificates
                               :get get-certificate
                               :delete delete-certificate})
