(ns genesis.providers.aws.elb.load-balancer
  (:require [amazonica.aws.elasticloadbalancingv2 :as elb]
            [genesis.providers.aws.ec2 :as gec2]
            [clojure.set :as set]
            [clojure.spec.alpha :as s]
            [clojure.data :as data]
            [genesis.core :as g :refer [defresource]]
            [genesis.util :refer [validate!]]))

(def list-load-balancers (gec2/list-with-identity elb/describe-load-balancers {:id-key :load-balancer-arn
                                                                                :require-args? true}))

(def get-load-balancer (gec2/get-by-identity list-load-balancers))

(s/def ::name string?)
(s/def ::scheme #{"internet-facing" "internal"})
(s/def ::type #{"application" "network"})
(s/def ::port pos-int?)
(s/def ::instance-port pos-int?)
(s/def ::protocol #{"HTTP" "HTTPS" "TCP"})

(s/def ::subnet-id string?)
(s/def ::allocation-id string?)

(s/def ::subnets (s/coll-of ::subnet-id))
(s/def ::subnet-mapping (s/keys :req-un [::subnet-id
                                         ::allocation-id]))
(s/def ::subnet-mappings (s/coll-of ::subnet-mapping))

(s/def ::load-balancer (s/keys :req-un [::name
                                        (or ::subnet-mappings
                                            ::subnets)]
                               :opt-un [::scheme
                                        ::type
                                        ::ip-address-type]))

(def create-load-balancer (gec2/create-with-identity elb/create-load-balancer {:spec ::load-balancer
                                                                                :id-key :load-balancer-arn
                                                                                :unwrap? true
                                                                                :unwrap-array? true}))


(def delete-load-balancer (gec2/delete-by-identity {:get-fn get-load-balancer
                                                    :delete-fn elb/delete-load-balancer
                                                    :id-key :load-balancer-arn}))

(defresource :elb/load-balancer {:create create-load-balancer
                                 :list list-load-balancers
                                 :get get-load-balancer
                                 :delete delete-load-balancer})
