# `guaranteed-rate/lein-serverless`

Use Leiningen to drive [`sls`
commands](https://serverless.com/framework/docs/providers/aws/cli-reference/).

Add to project's `:plugins`:

```clojure
[com.rate/lein-serverless the-latest-release]
```

Now, instead of invoking `sls` directly

```shellsession
$ sls deploy more args
```

you can use the `lein serverless` equivalent:

```shellsession
$ lein serverless deploy -- more args
```

## Subtasks

### `deploy`

`lein serverless deploy` invokes `sls deploy` with the environment
variable `LEIN_SERVERLESS_VERSION` populated with the version listed
in the `defproject`. The intended use case is so that projects using
this plugin can add that version to the `stackTags` in their
`serverless.yml`:

```yaml
provider:
  stackTags:
    com.rate:version: ${env:LEIN_SERVERLESS_VERSION}
```
