![re-flow logo](/images/re-flow.png)

re-flow is a library that adds tools for building and executing workflows in
[re-frame](https://github.com/Day8/re-frame) applications.

At Guaranteed Rate, we often find ourselves building applications that guide a
user through a complex workflow, such as finding or applying for a home loan.
re-flow is a library we developed to express these workflows as data and provide
tools to execute, debug, and visualize them.

Ultimately, re-flow provides an approach to building UIs similar to the one
described in
[this Cognitect blog post](https://blog.cognitect.com/blog/2017/5/22/restate-your-ui-using-state-machines-to-simplify-user-interface-development).

re-frame is an exceptionally awesome framework for building client applications
(thanks Mike et al!), and we designed re-flow to integrate tightly with its
interceptor facilities. re-flow is therefore pluggable by providing your own
custom interceptors. Most of the default functionality resides in interceptors,
so you can even strip it out if it does not fit your needs.

We are excited to share re-flow with you and would love to hear your feedback.
Please feel free to open an issue or contact a project maintainer directly.


## Installation

There are a few different environments that support re-flow, and each requires a
slightly different configuration.

### ClojureScript only

If you intend to use re-flow in a ClojureScript application without interacting
with flows using Clojure, include the following dependency in your project file.

```
[guaranteed-rate/re-flow "0.8.0"]
```

### Clojure 1.8

If you intend to use Clojure 1.8 to generate or manipulate flows, then you will
need to include the following dependencies. re-flow depends heavily upon spec
and uses [clojure-future-spec](https://github.com/tonsky/clojure-future-spec) to
provide those features.

```
[clojure-future-spec "1.9.0-beta4"]
[guaranteed-rate/re-flow "0.8.0"]
```

### Clojure 1.9

If you intend to use Clojure 1.9 to generate or manipulate flows, then you will
need to include the following dependencies. This version of Clojure 1.9 contains
the same structure of spec namespaces as the version of ClojureScript required
by re-frame.

```
[org.clojure/clojure "1.9.0"]
[guaranteed-rate/re-flow "0.8.0"]
```

### Clojure with Visualization

In order to build GraphViz-based visualizations of flows, you will need to
include the following in your project dependencies in addition to the
dependencies described in the previous sections.

```
[aysylu/loom "1.0.0"]
```


## Documentation

[API Docs](https://guaranteed-rate.github.io/re-flow/)

[Documentation](/doc)

[Examples](/examples)


## Usage

The following is a short but complete example of a re-frame application using
re-flow. This is the code used for the [ping-pong example](/examples/ping-pong),
but the example contains much more documentation. Be sure to check out the
[other examples](/examples).


```clojure
(ns ping-pong.core
  (:require [reagent.core :as reagent]
            [re-frame.core :as re-frame]
            [re-flow.core :as re-flow]))

;; Define a flow, which is just a vector of states and an option map containing
;; a value indicating which state is the start state.
(def ping-pong-flow
  (re-flow/flow [{:name :ping
                  :transition {:re-flow.transition/default :pong}}
                 {:name :pong
                  :transition {:re-flow.transition/default :ping}}]
                {:start :ping}))

(defn main-panel []
  ;; Subscribe to a flow's state. re-flow provides functions that wrap re-frame
  ;; functions like re-frame.core/subscribe for convenience, but you are free to
  ;; use the re-frame functions if you wish.
  (let [state (re-flow/sub-flow-state)]
    (fn []
      [:div
       [:p (:name @state)]

       ;; When the button is clicked, transition to the next state (no
       ;; transition data is provided in this case).
       [:button {:on-click #(re-flow/transition)} "Transition!"]])))

(defn mount-root []
  (re-frame/clear-subscription-cache!)
  (reagent/render [main-panel]
                  (.getElementById js/document "app")))

(defn ^:export init []
  ;; Dispatch an event to start the flow.
  (re-flow/start ping-pong-flow)
  (mount-root))
```

## License

Copyright © 2017-2018 Guaranteed Rate

Distributed under the [MIT license](LICENSE)