/*
 * Decompiled with CFR 0.152.
 */
package guitplugin;

import com.guit.client.apt.GwtController;
import com.guit.client.apt.GwtDisplay;
import guitplugin.Generated;
import guitplugin.guitview.GuitViewHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.xml.sax.SAXParseException;

@SupportedAnnotationTypes(value={"com.guit.client.apt.GwtPresenter", "com.guit.client.apt.GwtController"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class GuitPresenterProcessor
extends AbstractProcessor {
    String domPackage = "com.google.gwt.event.dom.client.";
    String sharedPackage = "com.google.gwt.event.logical.shared.";
    String aptPackage = "com.guit.client.apt.";
    private static final String containerError = "A gwt container method can only have 1 parameter of a type IsWidget";
    private Elements elementsUtil;
    private Filer filer;
    private Types typeUtils;
    private ProcessingEnvironment env;

    private void collectGetters(HashMap<String, ExecutableElement> validFields, TypeElement eventType) {
        TypeMirror typeMirror;
        if (eventType == null) {
            return;
        }
        List<ExecutableElement> classMethods = ElementFilter.methodsIn(this.elementsUtil.getAllMembers(eventType));
        for (ExecutableElement methodDeclaration : classMethods) {
            String name = methodDeclaration.getSimpleName().toString();
            TypeMirror returnType = methodDeclaration.getReturnType();
            if (returnType.getKind().equals((Object)TypeKind.VOID)) continue;
            if (name.startsWith("get")) {
                name = name.substring(3);
                name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
                validFields.put(name, methodDeclaration);
                continue;
            }
            if (!name.startsWith("is") || !this.typeUtils.getPrimitiveType(TypeKind.BOOLEAN).equals(returnType)) continue;
            name = name.substring(2);
            name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
            validFields.put(name, methodDeclaration);
        }
        List<? extends TypeMirror> superinterfaces = eventType.getInterfaces();
        for (TypeMirror typeMirror2 : superinterfaces) {
            this.collectGetters(validFields, (TypeElement)this.typeUtils.asElement(typeMirror2));
        }
        if (eventType.getKind().equals((Object)ElementKind.CLASS) && (typeMirror = eventType.getSuperclass()) != null) {
            this.collectGetters(validFields, (TypeElement)this.typeUtils.asElement(typeMirror));
        }
    }

    protected String eventClassNameToEventName(String simpleName) {
        String eventName = simpleName.substring(0, simpleName.length() - 5);
        eventName = String.valueOf(eventName.substring(0, 1).toLowerCase()) + eventName.substring(1);
        return eventName;
    }

    protected String eventNameToEventClassName(String eventName) {
        eventName = String.valueOf(eventName.substring(0, 1).toUpperCase()) + eventName.substring(1) + "Event";
        return eventName;
    }

    private String fieldsToString(Set<String> names) {
        StringBuilder sb = new StringBuilder();
        for (String f : names) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(f);
        }
        return sb.toString();
    }

    private HashMap<String, ExecutableElement> getValidFields(TypeElement eventType) {
        HashMap<String, ExecutableElement> validFields = new HashMap<String, ExecutableElement>();
        this.collectGetters(validFields, eventType);
        return validFields;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.env = this.processingEnv;
        if (roundEnv.processingOver()) {
            return false;
        }
        this.elementsUtil = this.env.getElementUtils();
        this.filer = this.env.getFiler();
        this.typeUtils = this.env.getTypeUtils();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (!element.getKind().equals((Object)ElementKind.CLASS)) continue;
                TypeElement d = (TypeElement)element;
                try {
                    this.generateBinder(d);
                    String annName = typeElement.getQualifiedName().toString();
                    if (annName.equals(GwtController.class.getCanonicalName())) {
                        this.generateControllerSuper(d);
                        this.processController(d);
                    } else if (annName.equals(String.valueOf(this.aptPackage) + "GwtPresenter")) {
                        HashMap<String, HashMap<String, String>> fieldsMap = null;
                        try {
                            fieldsMap = GuitViewHelper.findUiFields(this.filer, d);
                        }
                        catch (SAXParseException ex) {
                            this.printMessage(Diagnostic.Kind.NOTE, String.format("Error parsing XML (line " + ex.getLineNumber() + "): " + ex.getMessage(), new Object[0]), d);
                            this.printMessage(Diagnostic.Kind.ERROR, String.format("Error parsing XML (line " + ex.getLineNumber() + "): " + ex.getMessage(), new Object[0]), d);
                            continue;
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                        this.generatePresenterSuper(d, fieldsMap);
                        this.processController(d);
                        for (Map.Entry<String, HashMap<String, String>> entry : fieldsMap.entrySet()) {
                            this.processPresenterWithOneXml(d, entry.getKey(), entry.getValue());
                        }
                    }
                    for (ExecutableElement m : ElementFilter.methodsIn(this.elementsUtil.getAllMembers(d))) {
                        VariableElement parameter;
                        if (m.getAnnotation(GwtDisplay.class) == null) continue;
                        List<? extends VariableElement> parameters = m.getParameters();
                        if (parameters.size() != 1) {
                            this.printMessage(Diagnostic.Kind.ERROR, containerError, m);
                        }
                        if (!(parameter = (VariableElement)parameters.iterator().next()).asType().toString().equals("com.google.gwt.user.client.ui.IsWidget")) {
                            this.printMessage(Diagnostic.Kind.ERROR, containerError, parameter);
                        }
                        this.processContainerMethod(d, m);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return false;
    }

    private void printMessage(Diagnostic.Kind kind, String msg, Element e) {
        if (this.isEclipse()) {
            this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, msg, e);
        }
        this.env.getMessager().printMessage(kind, msg, e);
    }

    private boolean isEclipse() {
        try {
            this.filer.getResource(StandardLocation.SOURCE_PATH, "", "");
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private void generateBinder(TypeElement classDeclaration) {
        String packageName = this.elementsUtil.getPackageOf(classDeclaration).getQualifiedName().toString();
        String simpleName = classDeclaration.getSimpleName().toString();
        String name = String.valueOf(simpleName) + "Binder";
        String qualifiedName = String.valueOf(packageName) + "." + name;
        PrintWriter writer = this.getPrintWriter(qualifiedName);
        writer.println("package " + packageName + ";");
        writer.println();
        Generated.printGeneratedImport(writer);
        writer.println("import com.guit.client.binder.GuitBinder;");
        writer.println();
        List<? extends TypeParameterElement> parameters = classDeclaration.getTypeParameters();
        if (parameters != null && parameters.size() > 0) {
            writer.println("@SuppressWarnings(\"rawtypes\")");
        }
        Generated.printGenerated(writer, simpleName);
        writer.println("public interface " + name + " extends GuitBinder<" + simpleName + "> {");
        writer.println("}");
        writer.close();
    }

    private void generatePresenterSuper(TypeElement classDeclaration, HashMap<String, HashMap<String, String>> fieldsMap) {
        String packageName = this.elementsUtil.getPackageOf(classDeclaration).getQualifiedName().toString();
        String simpleName = classDeclaration.getSimpleName().toString();
        String name = String.valueOf(simpleName) + "Presenter";
        String qualifiedName = String.valueOf(packageName) + "." + name;
        PrintWriter writer = this.getPrintWriter(qualifiedName);
        writer.println("package " + packageName + ";");
        writer.println();
        Generated.printGenerated(writer, simpleName);
        String extendsPresenter = this.getExtendsPresenter(classDeclaration);
        TypeElement extendsPresenterElement = this.elementsUtil.getTypeElement(extendsPresenter);
        Set<String> allFields = this.getAllField(extendsPresenterElement);
        writer.println("public abstract class " + name + " extends " + extendsPresenter + "<" + simpleName + "Binder> {");
        this.printDriver(classDeclaration, writer);
        this.printDependencies(classDeclaration, writer);
        for (Map.Entry<String, String> entry : fieldsMap.entrySet().iterator().next().getValue().entrySet()) {
            if (allFields.contains(entry.getKey())) continue;
            if (entry.getValue().startsWith("com.guit.client.dom")) {
                writer.println();
                writer.println("  @com.guit.client.apt.Generated");
                writer.println("  @com.guit.client.binder.ViewField");
                writer.println("  " + entry.getValue() + " " + entry.getKey() + ";");
                continue;
            }
            if (!this.isPresenter(this.elementsUtil.getTypeElement(entry.getValue()))) continue;
            writer.println();
            writer.println("  @com.guit.client.apt.Generated");
            writer.println("  @com.google.inject.Inject");
            writer.println("  @com.guit.client.binder.ViewField(provided = true)");
            writer.println("  " + entry.getValue() + " " + entry.getKey() + ";");
        }
        writer.println("}");
        writer.close();
    }

    private boolean isPresenter(TypeElement type) {
        List<? extends AnnotationMirror> annotations = type.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            Element asElement = annotationMirror.getAnnotationType().asElement();
            String qualifiedName = ((TypeElement)asElement).getQualifiedName().toString();
            if (!qualifiedName.equals(String.valueOf(this.aptPackage) + "GwtPresenter")) continue;
            return true;
        }
        for (TypeMirror typeMirror : type.getInterfaces()) {
            if (!typeMirror.toString().equals("com.guit.client.Presenter")) continue;
            return true;
        }
        Element element = this.typeUtils.asElement(type.getSuperclass());
        if (element != null) {
            return this.isPresenter((TypeElement)element);
        }
        return false;
    }

    private Set<String> getAllField(TypeElement clazz) {
        HashSet<String> allFields = new HashSet<String>();
        for (VariableElement f : ElementFilter.fieldsIn(this.elementsUtil.getAllMembers(clazz))) {
            allFields.add(f.getSimpleName().toString());
        }
        return allFields;
    }

    private void printDependencies(TypeElement classDeclaration, PrintWriter writer) {
        try {
            this.printDependenciesMaven(classDeclaration, writer, this.filer.getResource(StandardLocation.SOURCE_PATH, this.elementsUtil.getPackageOf(classDeclaration).getQualifiedName().toString(), classDeclaration.getSimpleName() + ".java").getCharContent(true).toString());
        }
        catch (Exception exception) {
            this.printDependenciesEclipse(classDeclaration, writer);
        }
    }

    private void printDependenciesMaven(TypeElement classDeclaration, PrintWriter writer, String source) {
        HashMap<String, String> imports = new HashMap<String, String>();
        String[] lines = source.split("\\r?\\n");
        String injections = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            if (!(l = l.trim()).isEmpty()) {
                if (l.startsWith("import ")) {
                    l = l.substring(7, l.length() - 1);
                    imports.put(l.substring(l.lastIndexOf(".") + 1), l);
                } else if (l.startsWith("@Injections")) {
                    injections = l;
                    String substring = injections.substring(13, injections.length() - 2);
                    String[] stringArray2 = substring.split(",");
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String clazz = stringArray2[n4];
                        clazz = clazz.trim();
                        clazz = clazz.substring(0, clazz.length() - 6);
                        writer.println();
                        if (imports.containsKey(clazz)) {
                            clazz = (String)imports.get(clazz);
                        }
                        String name = clazz.substring(clazz.lastIndexOf(".") + 1);
                        writer.println("  @com.google.inject.Inject");
                        writer.println("  " + clazz + " " + name.substring(0, 1).toLowerCase() + name.substring(1) + ";");
                        ++n4;
                    }
                    return;
                }
            }
            ++n2;
        }
    }

    private void printDependenciesEclipse(TypeElement classDeclaration, PrintWriter writer) {
        List<? extends AnnotationMirror> annotations = classDeclaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            String annName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (!annName.equals("com.guit.client.apt.Injections")) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> v : values.entrySet()) {
                if (!v.getKey().getSimpleName().toString().equals("value")) continue;
                List classes = (List)v.getValue().getValue();
                for (Object inject : classes) {
                    String clazz = inject.toString();
                    if (clazz.equals("<error>")) {
                        return;
                    }
                    writer.println();
                    if (clazz.endsWith(".class")) {
                        clazz = clazz.substring(0, clazz.length() - 6);
                    }
                    String name = clazz.substring(clazz.lastIndexOf(".") + 1);
                    writer.println("  @com.google.inject.Inject");
                    writer.println("  " + clazz + " " + name.substring(0, 1).toLowerCase() + name.substring(1) + ";");
                }
                return;
            }
        }
    }

    private void printDriver(TypeElement classDeclaration, PrintWriter writer) {
        List<? extends AnnotationMirror> annotations = classDeclaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            String qualifiedName;
            Element decl = annotationMirror.getAnnotationType().asElement();
            if (decl == null || !(qualifiedName = ((TypeElement)decl).getQualifiedName().toString()).equals("com.guit.client.binder.GwtEditor")) continue;
            String pojo = null;
            String base = "com.google.gwt.editor.client.SimpleBeanEditorDriver";
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                String name = entry.getKey().getSimpleName().toString();
                if (name.equals("pojo")) {
                    pojo = entry.getValue().getValue().toString();
                    continue;
                }
                if (!name.equals("base")) continue;
                base = entry.getValue().getValue().toString();
            }
            if (pojo != null) {
                writer.println();
                writer.println("  " + base + "<" + pojo + ", ?> driver;");
            }
            return;
        }
    }

    private void generateControllerSuper(TypeElement classDeclaration) {
        String packageName = this.elementsUtil.getPackageOf(classDeclaration).getQualifiedName().toString();
        String simpleName = classDeclaration.getSimpleName().toString();
        String name = String.valueOf(simpleName) + "Controller";
        String qualifiedName = String.valueOf(packageName) + "." + name;
        PrintWriter writer = this.getPrintWriter(qualifiedName);
        writer.println("package " + packageName + ";");
        writer.println();
        writer.println("import com.guit.client.GuitController;");
        Generated.printGeneratedImport(writer);
        writer.println();
        String binderName = String.valueOf(simpleName) + "Binder";
        Generated.printGenerated(writer, simpleName);
        writer.println("public abstract class " + name + " extends GuitController<" + binderName + "> {");
        writer.println("}");
        writer.close();
    }

    private String getExtendsPresenter(TypeElement classDeclaration) {
        List<? extends AnnotationMirror> annotations = classDeclaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            String qualifiedName;
            Element decl = annotationMirror.getAnnotationType().asElement();
            if (decl == null || !(qualifiedName = ((TypeElement)decl).getQualifiedName().toString()).equals("com.guit.client.apt.GwtPresenter")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("extendsPresenter")) continue;
                return entry.getValue().getValue().toString();
            }
        }
        return "com.guit.client.GuitPresenter";
    }

    /*
     * WARNING - void declaration
     */
    private void processPresenterWithOneXml(TypeElement classDeclaration, String viewName, HashMap<String, String> hashMap) {
        List<? extends AnnotationMirror> annotations = classDeclaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            String qualifiedName;
            Element decl = annotationMirror.getAnnotationType().asElement();
            if (decl == null || !(qualifiedName = ((TypeElement)decl).getQualifiedName().toString()).equals("com.guit.client.apt.GwtPresenter")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror.getElementValues().entrySet()) {
                Object field;
                if (!e.getKey().getSimpleName().toString().equals("autofocus") || hashMap.containsKey(field = (String)e.getValue().getValue())) continue;
                this.printMessage(Diagnostic.Kind.ERROR, String.valueOf(viewName) + ". " + "The field '" + (String)field + "' is not declared in the view. Valid fields: " + this.fieldsToString(hashMap.keySet()), e.getKey());
            }
        }
        for (VariableElement variableElement : ElementFilter.fieldsIn(this.elementsUtil.getAllMembers(classDeclaration))) {
            void var10_22;
            void var10_19;
            List<? extends AnnotationMirror> annotationsMirror = variableElement.getAnnotationMirrors();
            AnnotationMirror viewField = null;
            boolean isGenerated = false;
            for (AnnotationMirror annotationMirror : annotationsMirror) {
                Element declaration = annotationMirror.getAnnotationType().asElement();
                if (declaration.toString().equals("com.guit.client.binder.ViewField")) {
                    viewField = annotationMirror;
                    continue;
                }
                if (!declaration.toString().equals("com.guit.client.apt.Generated")) continue;
                isGenerated = true;
            }
            if (viewField == null || isGenerated) continue;
            Object var10_18 = null;
            Boolean provided = false;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = viewField.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                String simpleName = entry.getKey().getSimpleName().toString();
                if (simpleName.equals("name")) {
                    String string = (String)entry.getValue().getValue();
                }
                if (!entry.getKey().getSimpleName().equals("provided")) continue;
                provided = (Boolean)entry.getValue().getValue();
            }
            ElementKind elementKind = variableElement.getKind();
            if (!provided.booleanValue() && elementKind.isClass()) {
                this.printMessage(Diagnostic.Kind.ERROR, String.valueOf(viewName) + ". " + "The type of a @ViewField must be an interface", variableElement);
            }
            if (var10_19 == null) {
                String string = variableElement.getSimpleName().toString();
            }
            if (!hashMap.containsKey(var10_22)) {
                this.printMessage(Diagnostic.Kind.ERROR, String.valueOf(viewName) + ". " + "The field '" + (String)var10_22 + "' is not declared in the view. Valid fields: " + this.fieldsToString(hashMap.keySet()), variableElement);
                continue;
            }
            if (!hashMap.get(var10_22).startsWith("com.guit.client.dom") || !variableElement.getEnclosingElement().toString().equals(classDeclaration.getQualifiedName().toString())) continue;
            this.printMessage(Diagnostic.Kind.ERROR, String.valueOf(viewName) + ". " + "The field '" + (String)var10_22 + "' is already declared on the super class", variableElement);
        }
        List<ExecutableElement> list = ElementFilter.methodsIn(this.elementsUtil.getAllMembers(classDeclaration));
        for (ExecutableElement m : list) {
            boolean bl;
            List<? extends AnnotationMirror> annotationsMirror = m.getAnnotationMirrors();
            boolean isViewHandler = false;
            boolean bl2 = false;
            TypeElement eventType = null;
            ExecutableElement eventTypeDeclaration = null;
            for (AnnotationMirror annotationMirror : annotationsMirror) {
                Element declaration = annotationMirror.getAnnotationType().asElement();
                if (!((TypeElement)declaration).getQualifiedName().toString().equals("com.guit.client.binder.ViewHandler")) continue;
                isViewHandler = true;
                Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                    String simpleName = entry.getKey().getSimpleName().toString();
                    if (simpleName.equals("event")) {
                        eventTypeDeclaration = entry.getKey();
                        Object value = entry.getValue().getValue();
                        eventType = (TypeElement)this.typeUtils.asElement((TypeMirror)value);
                        continue;
                    }
                    if (!simpleName.equals("fields")) continue;
                    bl = true;
                    List viewFields = (List)entry.getValue().getValue();
                    for (AnnotationValue value : viewFields) {
                        String field = (String)value.getValue();
                        if (hashMap.containsKey(field)) continue;
                        this.printMessage(Diagnostic.Kind.ERROR, String.valueOf(viewName) + ". " + "The field '" + field + "' is not declared in the view. Valid fields: " + this.fieldsToString(hashMap.keySet()), m);
                    }
                }
            }
            if (!isViewHandler) continue;
            if (!bl) {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(m.getSimpleName().toString().split("[$]")));
                int n = arrayList.size() - 1;
                String eventName = (String)arrayList.get(n);
                if (eventType != null && !"com.google.gwt.event.shared.GwtEvent".equals(eventType.getQualifiedName())) {
                    String currentEventName;
                    String simpleName = eventType.getSimpleName().toString();
                    if (!simpleName.endsWith("Event")) {
                        this.printMessage(Diagnostic.Kind.ERROR, String.valueOf(viewName) + ". " + "The event type does not match with the convention, it must end with 'Event'", eventTypeDeclaration);
                    }
                    if (!eventName.equals(currentEventName = this.eventClassNameToEventName(simpleName))) {
                        this.printMessage(Diagnostic.Kind.ERROR, String.valueOf(viewName) + ". " + "The method name must end with '" + currentEventName + "'", m);
                    }
                } else {
                    String currentPackage = String.valueOf(this.elementsUtil.getPackageOf(classDeclaration).getQualifiedName().toString()) + ".event.";
                    String eventClassName = this.eventNameToEventClassName(eventName);
                    eventType = this.elementsUtil.getTypeElement(String.valueOf(this.domPackage) + (String)eventClassName);
                    if (eventType == null) {
                        eventType = this.elementsUtil.getTypeElement(String.valueOf(this.sharedPackage) + (String)eventClassName);
                    }
                    if (eventType == null) {
                        eventType = this.elementsUtil.getTypeElement(String.valueOf(currentPackage) + (String)eventClassName);
                    }
                    if (eventType == null) {
                        this.printMessage(Diagnostic.Kind.WARNING, "The event cannot be found. Do you see any typo in the name? '" + eventName + "'. i.e: ClickEvent -> click", m);
                    }
                }
                arrayList.remove(n);
                for (String part : arrayList) {
                    if (hashMap.containsKey(part)) continue;
                    this.printMessage(Diagnostic.Kind.ERROR, String.valueOf(viewName) + ". " + "The field '" + part + "' is not declared in the view. Valid fields: " + this.fieldsToString(hashMap.keySet()), m);
                    break;
                }
            } else if (eventType == null) {
                this.printMessage(Diagnostic.Kind.ERROR, String.valueOf(viewName) + ". " + "When using the @ViewFields annotation you need to specify the event type on the @ViewHandler annotation", m);
            }
            List<? extends VariableElement> list2 = m.getParameters();
            block10: for (VariableElement variableElement : list2) {
                boolean isAttribute = false;
                List<? extends AnnotationMirror> parameterAnnotations = variableElement.getAnnotationMirrors();
                for (AnnotationMirror annotationMirror : parameterAnnotations) {
                    if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals("com.guit.client.binder.Attribute")) continue;
                    isAttribute = true;
                    break;
                }
                if (isAttribute) {
                    if (!variableElement.asType().getKind().isPrimitive()) continue;
                    this.printMessage(Diagnostic.Kind.ERROR, String.valueOf(viewName) + ". " + "@Attribute parameters cannot be of a primitive type. The type must implement valueOf(String value)", variableElement);
                    continue;
                }
                String string = variableElement.getSimpleName().toString();
                String[] parts = string.split("[$]");
                HashMap<String, ExecutableElement> validFields = this.getValidFields(eventType);
                StringBuilder sb = new StringBuilder();
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    if (sb.length() > 0) {
                        sb.append(".");
                    }
                    if (!validFields.keySet().contains(part)) {
                        this.printMessage(Diagnostic.Kind.ERROR, String.valueOf(viewName) + ". " + "The event '" + eventType.getQualifiedName() + "' does not have a getter method for '" + sb.toString() + part + "'", variableElement);
                        continue block10;
                    }
                    TypeMirror returnClassType = validFields.get(part).getReturnType();
                    if (this.typeUtils.asElement(returnClassType) instanceof TypeElement) {
                        validFields = this.getValidFields((TypeElement)this.typeUtils.asElement(returnClassType));
                    }
                    sb.append(part);
                    ++n2;
                }
            }
        }
    }

    private void processController(TypeElement classDeclaration) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(this.elementsUtil.getAllMembers(classDeclaration));
        for (ExecutableElement m : methods) {
            String string;
            List<? extends AnnotationMirror> annotationsMirror = m.getAnnotationMirrors();
            TypeElement eventType = null;
            ExecutableElement eventTypeDeclaration = null;
            boolean isEventBusHandler = false;
            for (AnnotationMirror annotationMirror : annotationsMirror) {
                Element declaration = annotationMirror.getAnnotationType().asElement();
                if (declaration == null || !((TypeElement)declaration).getQualifiedName().toString().equals("com.guit.client.binder.EventBusHandler")) continue;
                isEventBusHandler = true;
                Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                    eventTypeDeclaration = entry.getKey();
                    try {
                        Object value = entry.getValue().getValue();
                        eventType = (TypeElement)this.typeUtils.asElement((TypeMirror)value);
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
            if (!isEventBusHandler) continue;
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(m.getSimpleName().toString().split("[$]")));
            if (arrayList.size() != 2 || !((String)arrayList.get(0)).equals("eventBus") && !((String)arrayList.get(0)).isEmpty()) {
                this.printMessage(Diagnostic.Kind.ERROR, "The method name must be 'eventBus${eventname}' or '${eventname}'", m);
                continue;
            }
            String eventName = (String)arrayList.get(1);
            if (eventType == null || "com.google.gwt.event.shared.GwtEvent".equals(eventType.getQualifiedName())) continue;
            String simpleName = eventType.getSimpleName().toString();
            if (!simpleName.endsWith("Event")) {
                this.printMessage(Diagnostic.Kind.ERROR, "The event type does not match with the convention, it must end with 'Event'", eventTypeDeclaration);
            }
            if (!eventName.equals(string = this.eventClassNameToEventName(simpleName))) {
                this.printMessage(Diagnostic.Kind.ERROR, "The method name must end with '" + string + "'", m);
            }
            List<? extends VariableElement> parameters = m.getParameters();
            for (VariableElement variableElement : parameters) {
                List<? extends AnnotationMirror> parameterAnnotations = variableElement.getAnnotationMirrors();
                boolean hasAttribute = false;
                for (AnnotationMirror annotationMirror : parameterAnnotations) {
                    if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals("com.guit.client.binder.Attribute")) continue;
                    hasAttribute = true;
                    break;
                }
                if (hasAttribute) {
                    this.printMessage(Diagnostic.Kind.ERROR, "@Attribute parameters are not allowed in EventBusHandler methods", variableElement);
                    continue;
                }
                String string2 = variableElement.getSimpleName().toString();
                String[] parts = string2.split("[$]");
                HashMap<String, ExecutableElement> validFields = this.getValidFields(eventType);
                StringBuilder sb = new StringBuilder();
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    if (sb.length() > 0) {
                        sb.append(".");
                    }
                    if (!validFields.keySet().contains(part)) {
                        this.printMessage(Diagnostic.Kind.ERROR, "The event '" + eventType.getQualifiedName() + "' does not have a getter method for '" + sb.toString() + part + "'. Valid fields: " + validFields.keySet().toString(), variableElement);
                    } else {
                        TypeMirror retType = validFields.get(part).getReturnType();
                        validFields = this.getValidFields((TypeElement)this.typeUtils.asElement(retType));
                        sb.append(part);
                    }
                    ++n2;
                }
            }
        }
    }

    private void processContainerMethod(TypeElement d, ExecutableElement m) {
        String containerName = null;
        List<? extends AnnotationMirror> mirrors = m.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals(GwtDisplay.class.getCanonicalName())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("value")) continue;
                containerName = (String)entry.getValue().getValue();
            }
        }
        if (containerName == null) {
            return;
        }
        String string = containerName;
        String packageName = this.elementsUtil.getPackageOf(d).getQualifiedName().toString();
        String qualifiedName = String.valueOf(packageName) + "." + string;
        PrintWriter writer = this.getPrintWriter(qualifiedName);
        writer.println("package " + packageName + ";");
        writer.println();
        writer.println("import java.lang.annotation.Documented;");
        writer.println("import java.lang.annotation.Retention;");
        writer.println("import java.lang.annotation.RetentionPolicy;");
        writer.println();
        writer.println("import com.google.inject.BindingAnnotation;");
        Generated.printGeneratedImport(writer);
        writer.println();
        writer.println("@BindingAnnotation");
        writer.println("@Retention(RetentionPolicy.RUNTIME)");
        writer.println("@Documented");
        writer.println();
        Generated.printGenerated(writer, d.getSimpleName().toString());
        writer.println("public @interface " + string + "{");
        writer.println("}");
        writer.close();
        String string2 = String.valueOf(containerName) + "Provider";
        qualifiedName = String.valueOf(packageName) + "." + string2;
        writer = this.getPrintWriter(qualifiedName);
        writer.println("package " + packageName + ";");
        writer.println();
        writer.println("import com.google.gwt.user.client.ui.AcceptsOneWidget;");
        writer.println("import com.google.gwt.user.client.ui.IsWidget;");
        writer.println("import com.google.inject.Inject;");
        writer.println("import com.google.inject.Provider;");
        writer.println("import com.google.inject.Singleton;");
        Generated.printGeneratedImport(writer);
        writer.println();
        writer.println("@Singleton");
        Generated.printGenerated(writer, d.getSimpleName().toString());
        writer.println("public class " + string2 + " implements Provider<AcceptsOneWidget>, AcceptsOneWidget {");
        writer.println();
        writer.println("  @Inject");
        writer.println("  " + d.getQualifiedName() + " owner;");
        writer.println();
        writer.println("  @Override");
        writer.println("  public void setWidget(IsWidget w) {");
        writer.println("    owner." + m.getSimpleName() + "(w);");
        writer.println("  }");
        writer.println();
        writer.println("  @Override");
        writer.println("  public AcceptsOneWidget get() {");
        writer.println("    return this;");
        writer.println("  }");
        writer.println("}");
        writer.close();
        String string3 = String.valueOf(containerName) + "Module";
        qualifiedName = String.valueOf(packageName) + "." + string3;
        writer = this.getPrintWriter(qualifiedName);
        writer.println("package " + packageName + ";");
        writer.println();
        writer.println("import com.google.gwt.inject.client.AbstractGinModule;");
        writer.println("import com.google.gwt.user.client.ui.AcceptsOneWidget;");
        Generated.printGeneratedImport(writer);
        writer.println();
        Generated.printGenerated(writer, d.getSimpleName().toString());
        writer.println("public class " + string3 + " extends AbstractGinModule {");
        writer.println();
        writer.println("  @Override");
        writer.println("  protected void configure() {");
        writer.println("    bind(AcceptsOneWidget.class).annotatedWith(" + containerName + ".class).toProvider(" + containerName + "Provider.class);");
        writer.println("  }");
        writer.println("}");
        writer.close();
    }

    public PrintWriter getPrintWriter(String qualifiedName) {
        try {
            JavaFileObject createSourceFile = this.filer.createSourceFile(qualifiedName, new Element[0]);
            return new PrintWriter(createSourceFile.openWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

