/*
 * Decompiled with CFR 0.152.
 */
package guitplugin;

import com.guit.client.apt.Cache;
import com.guit.client.apt.GuitService;
import com.guit.client.apt.Ignore;
import guitplugin.Generated;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.guit.client.apt.GuitService"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class GuitServiceProcessor
extends AbstractProcessor {
    private Elements elementsUtil;
    private Filer filer;
    private Types typeUtils;
    private ProcessingEnvironment env;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.env = this.processingEnv;
        this.elementsUtil = this.env.getElementUtils();
        this.filer = this.env.getFiler();
        this.typeUtils = this.env.getTypeUtils();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (!element.getKind().equals((Object)ElementKind.INTERFACE)) continue;
                TypeElement d = (TypeElement)element;
                List<? extends AnnotationMirror> mirrors = d.getAnnotationMirrors();
                List interfaces = new ArrayList();
                for (AnnotationMirror annotationMirror : mirrors) {
                    String name = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                    if (!name.equals(GuitService.class.getCanonicalName())) continue;
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                        interfaces = (List)entry.getValue().getValue();
                    }
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (AnnotationValue a : interfaces) {
                    arrayList.add((String)a.getValue());
                }
                this.generateRpcService(d, arrayList);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void generateRpcService(TypeElement d, ArrayList<String> implement) {
        PackageElement pack = this.elementsUtil.getPackageOf(d);
        String dpackage = pack.getQualifiedName().toString();
        if (!pack.getSimpleName().toString().equals("server")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "All services must be on a 'server' package", d);
            return;
        }
        String clientPkg = String.valueOf(dpackage.substring(0, dpackage.lastIndexOf("."))) + ".client";
        String actionPkg = String.valueOf(clientPkg) + ".action";
        String hanlderPkg = String.valueOf(dpackage) + ".handler";
        List<ExecutableElement> methods = ElementFilter.methodsIn(this.elementsUtil.getAllMembers(d));
        String serviceName = d.getSimpleName().toString();
        HashSet<String> createdMethods = new HashSet<String>();
        String asyncServiceName = String.valueOf(serviceName) + "Async";
        PrintWriter asyncServiceWriter = this.getPrintWriter(String.valueOf(clientPkg) + "." + asyncServiceName);
        asyncServiceWriter.println("package " + clientPkg + ";");
        asyncServiceWriter.println();
        asyncServiceWriter.println("import com.google.inject.Inject;");
        asyncServiceWriter.println();
        asyncServiceWriter.println("import com.guit.client.async.AbstractAsyncCallback;");
        asyncServiceWriter.println("import com.guit.client.command.Async;");
        asyncServiceWriter.println("import com.guit.client.command.AsyncMethod;");
        asyncServiceWriter.println("import com.guit.client.command.CommandService;");
        Generated.printGeneratedImport(asyncServiceWriter);
        asyncServiceWriter.println();
        asyncServiceWriter.println("/**");
        asyncServiceWriter.println(" * Async access to " + serviceName);
        asyncServiceWriter.println(" */");
        Generated.printGenerated(asyncServiceWriter, serviceName);
        asyncServiceWriter.print("public class " + asyncServiceName);
        if (implement.size() > 0) {
            asyncServiceWriter.print(" implements ");
            boolean first = true;
            for (String i : implement) {
                if (first) {
                    first = false;
                } else {
                    asyncServiceWriter.print(", ");
                }
                asyncServiceWriter.print(i);
            }
        }
        asyncServiceWriter.println(" {");
        asyncServiceWriter.println();
        asyncServiceWriter.println("  private final CommandService commandService;");
        asyncServiceWriter.println();
        asyncServiceWriter.println("  @Inject");
        asyncServiceWriter.println("  public " + asyncServiceName + "(CommandService commandService) {");
        asyncServiceWriter.println("    this.commandService = commandService;");
        asyncServiceWriter.println("  }");
        asyncServiceWriter.println();
        for (ExecutableElement m : methods) {
            if (((TypeElement)m.getEnclosingElement()).getQualifiedName().toString().equals("java.lang.Object") || m.getAnnotation(Ignore.class) != null) continue;
            String methodName = m.getSimpleName().toString();
            methodName = String.valueOf(methodName.substring(0, 1).toUpperCase()) + methodName.substring(1);
            String postfix = "";
            int count = 0;
            while (createdMethods.contains(String.valueOf(methodName) + postfix)) {
                postfix = String.valueOf(count);
                ++count;
            }
            createdMethods.add(methodName);
            HashMap<String, String> actionFields = new HashMap<String, String>();
            String handlerClass = String.valueOf(dpackage) + ".handler." + serviceName + methodName + "Handler" + postfix;
            String actionClass = String.valueOf(actionPkg) + "." + serviceName + methodName + "Action" + postfix;
            String responseClass = String.valueOf(actionPkg) + "." + serviceName + methodName + "Response" + postfix;
            StringBuilder gettersList = new StringBuilder();
            List<? extends VariableElement> parameters = m.getParameters();
            for (VariableElement variableElement : parameters) {
                String pName = variableElement.getSimpleName().toString();
                actionFields.put(pName, variableElement.asType().toString());
                if (gettersList.length() > 0) {
                    gettersList.append(", ");
                }
                pName = String.valueOf(pName.substring(0, 1).toUpperCase()) + pName.substring(1);
                gettersList.append("action.get" + pName + "()");
            }
            TypeMirror typeMirror = m.getReturnType();
            boolean doesntReturnsVoid = typeMirror != null && !typeMirror.getKind().equals((Object)TypeKind.VOID);
            String responseFields = null;
            if (doesntReturnsVoid) {
                responseFields = typeMirror.toString();
            }
            this.generateAction(serviceName, actionFields, responseFields, handlerClass, methodName, actionPkg, m.getAnnotation(Cache.class) != null, postfix);
            try {
                void var31_36;
                PrintWriter writer = this.getPrintWriter(handlerClass);
                String service = d.getQualifiedName().toString();
                writer.println("package " + hanlderPkg + ";");
                writer.println();
                writer.println("import com.google.inject.Inject;");
                writer.println();
                writer.println("import com.guit.client.command.action.CommandException;");
                writer.println("import com.guit.client.command.action.Handler;");
                writer.println("import " + service + ";");
                Generated.printGeneratedImport(writer);
                writer.println();
                Generated.printGenerated(writer, serviceName);
                writer.println("public class " + serviceName + methodName + "Handler" + postfix + " implements Handler<" + actionClass + ", " + responseClass + "> {");
                ArrayList<String> preprocessors = new ArrayList<String>();
                List<? extends AnnotationMirror> annotations = m.getAnnotationMirrors();
                for (AnnotationMirror annotationMirror : annotations) {
                    TypeElement a = (TypeElement)annotationMirror.getAnnotationType().asElement();
                    List<? extends AnnotationMirror> list = a.getAnnotationMirrors();
                    for (AnnotationMirror annotationMirror2 : list) {
                        if (!((TypeElement)annotationMirror2.getAnnotationType().asElement()).getQualifiedName().toString().equals("com.guit.server.command.PreprocesorAnnotation")) continue;
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror2.getElementValues().entrySet()) {
                            Object value = entry.getValue().getValue();
                            TypeElement preprocesorType = (TypeElement)this.typeUtils.asElement((TypeMirror)value);
                            writer.println();
                            writer.println("  @Inject");
                            String qualifiedName = preprocesorType.getQualifiedName().toString();
                            String fieldName = qualifiedName.replaceAll("[.]", "_");
                            writer.println("  " + qualifiedName + " " + fieldName + ";");
                            String annotation = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                            String annFieldName = String.valueOf(fieldName) + "Annotation";
                            writer.append("  private static " + annotation + " " + annFieldName + ";");
                            writer.println("  static {");
                            writer.println("    try {");
                            writer.print("      " + annFieldName + " = " + service + ".class.getDeclaredMethod(\"" + m.getSimpleName() + "\", new Class[]{");
                            boolean first = true;
                            for (VariableElement variableElement : m.getParameters()) {
                                String type;
                                int indexOf;
                                if (!first) {
                                    writer.print(",");
                                }
                                if ((indexOf = (type = variableElement.asType().toString()).indexOf("<")) > 0) {
                                    type = type.substring(0, indexOf);
                                }
                                writer.print(String.valueOf(type) + ".class");
                                first = false;
                            }
                            writer.println("}).getAnnotation(" + annotation + ".class);");
                            writer.println("    } catch(" + NoSuchMethodException.class.getCanonicalName() + " e) {");
                            writer.println("      throw new " + RuntimeException.class.getCanonicalName() + "(e);");
                            writer.println("    }");
                            writer.println("  }");
                            preprocessors.add(fieldName);
                        }
                    }
                }
                writer.println();
                writer.println("  @Inject");
                writer.println("  " + serviceName + " service;");
                writer.println();
                writer.println("  @Override");
                writer.println("  public " + responseClass + " handle(" + actionClass + " action) throws CommandException {");
                for (String string : preprocessors) {
                    writer.println("    " + string + ".run(" + string + "Annotation);");
                }
                if (doesntReturnsVoid) {
                    writer.println("    return new " + responseClass + "(service." + m.getSimpleName() + "(" + gettersList + "));");
                } else {
                    writer.println("    service." + m.getSimpleName() + "(" + gettersList + ");");
                    writer.println("    return new " + responseClass + "();");
                }
                writer.println("  }");
                writer.println("}");
                writer.close();
                methodName = String.valueOf(methodName.substring(0, 1).toUpperCase()) + methodName.substring(1);
                TypeMirror rt = m.getReturnType();
                if (rt.getKind().isPrimitive()) {
                    String string2 = rt.toString();
                    string2 = "java.lang." + string2.substring(0, 1).toUpperCase() + string2.substring(1);
                } else if (rt.getKind().equals((Object)TypeKind.VOID)) {
                    String string = "java.lang.Void";
                } else {
                    String string = rt.toString();
                }
                asyncServiceWriter.println();
                asyncServiceWriter.println("  /**");
                asyncServiceWriter.println("   * Async call to " + serviceName + "." + methodName);
                asyncServiceWriter.println("   */");
                asyncServiceWriter.print("  public AsyncMethod<");
                asyncServiceWriter.print((String)var31_36);
                asyncServiceWriter.print(">");
                asyncServiceWriter.print(" ");
                asyncServiceWriter.print(m.getSimpleName());
                asyncServiceWriter.print("(");
                boolean first = true;
                for (VariableElement variableElement : m.getParameters()) {
                    if (!first) {
                        asyncServiceWriter.print(", ");
                    } else {
                        first = false;
                    }
                    asyncServiceWriter.print(variableElement.asType().toString());
                    asyncServiceWriter.print(" ");
                    asyncServiceWriter.print(variableElement.getSimpleName());
                }
                asyncServiceWriter.println(") {");
                asyncServiceWriter.println("    final " + actionClass + " action = new " + actionClass + "();");
                for (VariableElement variableElement : m.getParameters()) {
                    String parameterName = variableElement.getSimpleName().toString();
                    asyncServiceWriter.println("    action.set" + parameterName.substring(0, 1).toUpperCase() + parameterName.substring(1) + "(" + parameterName + ");");
                }
                asyncServiceWriter.println("    return new AsyncMethod<" + (String)var31_36 + ">() {");
                asyncServiceWriter.println();
                asyncServiceWriter.println("      public void fire(final Async<" + (String)var31_36 + "> async) {");
                asyncServiceWriter.println("        commandService.execute(action, new AbstractAsyncCallback<");
                asyncServiceWriter.println("            " + responseClass + ">() {");
                asyncServiceWriter.println("          public void success(" + responseClass + " response) {");
                asyncServiceWriter.println("            async.success(" + (var31_36.equals(Void.class.getCanonicalName()) ? "null" : "response.getResult()") + ");");
                asyncServiceWriter.println("          }");
                asyncServiceWriter.println();
                asyncServiceWriter.println("          public void failure(" + Throwable.class.getCanonicalName() + " ex) {");
                asyncServiceWriter.println("            async.failure(ex);");
                asyncServiceWriter.println("          }");
                asyncServiceWriter.println("        });");
                asyncServiceWriter.println("      }");
                asyncServiceWriter.println("    };");
                asyncServiceWriter.println("  }");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        asyncServiceWriter.println("}");
        asyncServiceWriter.close();
    }

    public void generateAction(String serviceName, HashMap<String, String> actionFields, String responseField, String handlerClass, String simpleName, String packageName, boolean cacheable, String postfix) {
        String actionName = String.valueOf(serviceName) + simpleName + "Action" + postfix;
        String responseName = String.valueOf(serviceName) + simpleName + "Response" + postfix;
        PrintWriter writer = this.getPrintWriter(String.valueOf(packageName) + "." + actionName);
        writer.println("package " + packageName + ";");
        if (cacheable) {
            writer.println("import com.guit.client.command.action.Cacheable;");
        }
        writer.println("import com.guit.client.command.HashCodeBuilder;");
        writer.println("import com.guit.client.command.action.Action;");
        writer.println("import com.guit.client.command.action.ActionHandler;");
        writer.println("import " + packageName + "." + responseName + ";");
        Generated.printGeneratedImport(writer);
        Generated.printGenerated(writer, simpleName);
        writer.println("@ActionHandler(\"" + handlerClass + "\")");
        writer.print("public class " + actionName + " implements Action<" + responseName + ">");
        if (cacheable) {
            writer.print(", Cacheable ");
        }
        writer.println(" {");
        StringBuilder actionString = new StringBuilder();
        for (Map.Entry<String, String> f : actionFields.entrySet()) {
            String type = f.getValue();
            String name = f.getKey();
            GuitServiceProcessor.printGetterAndSetter(writer, type, name, actionName);
            if (actionString.length() > 0) {
                actionString.append(", ");
            }
            actionString.append(String.valueOf(name) + "=" + "\" + " + name + " + \"");
        }
        writer.println("  public " + actionName + "() {");
        writer.println("  }");
        writer.println("  public boolean equals(Object o) {");
        writer.println("    if (this == null) {");
        writer.println("        return false;");
        writer.println("    }");
        writer.println("    if (this == o) {");
        writer.println("        return true;");
        writer.println("    }");
        writer.println("    if (o instanceof " + actionName + ") { return o.hashCode() == hashCode(); } else { return super.equals(o);}");
        writer.println("  }");
        writer.println("  public int hashCode() {");
        writer.print("    return new HashCodeBuilder()");
        for (Map.Entry<String, String> f : actionFields.entrySet()) {
            String name = f.getKey();
            writer.print(".append(" + name + ")");
        }
        writer.println(".toHashCode();");
        writer.println("  }");
        writer.println("  public String toString() {");
        writer.println("      if (!com.google.gwt.core.client.GWT.isScript()) {");
        writer.println("          return \"" + actionName + "[" + actionString.toString() + "]\";");
        writer.println("      }");
        writer.println("      return super.toString();");
        writer.println("  }");
        writer.println("}");
        writer.close();
        writer = this.getPrintWriter(String.valueOf(packageName) + "." + responseName);
        writer.println("package " + packageName + ";");
        writer.println("import com.guit.client.command.action.Response;");
        Generated.printGeneratedImport(writer);
        Generated.printGenerated(writer, simpleName);
        writer.println("public class " + responseName + " implements Response {");
        StringBuilder responseString = new StringBuilder();
        if (responseField != null) {
            GuitServiceProcessor.printGetterAndSetter(writer, responseField, "result", responseName);
            if (responseString.length() > 0) {
                responseString.append(", ");
            }
            responseString.append("result = \" + result + \"");
        }
        writer.println("  public String toString() {");
        writer.println("      if (!com.google.gwt.core.client.GWT.isScript()) {");
        writer.println("          return \"" + responseName + "[" + responseString.toString() + "]\";");
        writer.println("      }");
        writer.println("      return super.toString();");
        writer.println("  }");
        writer.println("  public " + responseName + "() {");
        writer.println("  }");
        if (responseField != null) {
            writer.println("  public " + responseName + "(" + responseField + " result) {");
            writer.println("    this.result = result;");
            writer.println("  }");
        }
        writer.println("}");
        writer.close();
    }

    private static void printGetterAndSetter(PrintWriter writer, String type, String name, String className) {
        writer.println("  private " + type + " " + name + ";");
        writer.println("  public " + type + " get" + name.substring(0, 1).toUpperCase() + name.substring(1) + "() {");
        writer.println("    return " + name + ";");
        writer.println("  }");
        writer.println("  public void set" + name.substring(0, 1).toUpperCase() + name.substring(1) + "(" + type + " " + name + ") {");
        writer.println("    this." + name + " = " + name + ";");
        writer.println("  }");
    }

    public PrintWriter getPrintWriter(String qualifiedName) {
        try {
            return new PrintWriter(this.filer.createSourceFile(qualifiedName, new Element[0]).openWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

