/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.bridge;

import com.google.appengine.repackaged.com.google.protobuf.BlockingService;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.ServiceException;
import com.google.appengine.repackaged.com.google.protobuf.bridge.AbstractStubbyService;
import com.google.appengine.repackaged.com.google.protobuf.bridge.DowngradedMessage;
import com.google.appengine.repackaged.com.google.protobuf.bridge.StubbyRpcController;
import com.google.appengine.repackaged.com.google.protobuf.bridge.StubbyServiceException;
import com.google.net.rpc.RPC;
import com.google.net.rpc.impl.ApplicationHandler;

public class BlockingStubbyService
extends AbstractStubbyService {
    private final BlockingService service;

    public BlockingStubbyService(BlockingService service) {
        this(service, service.getDescriptorForType().getName(), ExtensionRegistry.getEmptyRegistry());
    }

    public BlockingStubbyService(BlockingService service, String serviceName) {
        this(service, serviceName, ExtensionRegistry.getEmptyRegistry());
    }

    public BlockingStubbyService(BlockingService service, ExtensionRegistry registry) {
        this(service, service.getDescriptorForType().getName(), registry);
    }

    public BlockingStubbyService(BlockingService service, String serviceName, ExtensionRegistry registry) {
        super(serviceName, registry);
        this.service = service;
    }

    @Override
    Descriptors.ServiceDescriptor getDescriptorForType() {
        return this.service.getDescriptorForType();
    }

    @Override
    Message getRequestPrototype(Descriptors.MethodDescriptor method) {
        return this.service.getRequestPrototype(method);
    }

    @Override
    Message getResponsePrototype(Descriptors.MethodDescriptor method) {
        return this.service.getResponsePrototype(method);
    }

    @Override
    ApplicationHandler newApplicationHandler(Descriptors.MethodDescriptor methodDescriptor, ExtensionRegistry extensionRegistry) {
        return new BlockingStubbyApplicationHandler(methodDescriptor, this.service, extensionRegistry);
    }

    static final class BlockingStubbyApplicationHandler
    extends AbstractStubbyService.AbstractStubbyApplicationHandler {
        private final Descriptors.MethodDescriptor methodDescriptor;
        private final BlockingService service;

        BlockingStubbyApplicationHandler(Descriptors.MethodDescriptor methodDescriptor, BlockingService service, ExtensionRegistry registry) {
            super(registry);
            this.methodDescriptor = methodDescriptor;
            this.service = service;
        }

        @Override
        void internalHandleRequest(RPC rpc, StubbyRpcController controller) {
            DowngradedMessage query = (DowngradedMessage)rpc.internalRequest();
            DowngradedMessage response = (DowngradedMessage)rpc.internalResponse();
            try {
                Message reply = this.service.callBlockingMethod(this.methodDescriptor, controller, query.getProto2Message());
                response.setProto2Message(reply);
            }
            catch (StubbyServiceException e) {
                controller.getStubbyRpc().setApplicationError(e.appErrorCode(), e.getMessage());
            }
            catch (ServiceException e) {
                controller.setFailed(e.getMessage());
            }
            rpc.internalCallback().rpcFinished();
        }

        @Override
        String getStreamType() {
            return this.methodDescriptor.getOptions().getStreamType();
        }
    }
}

