/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.log.dev.LocalLogService;
import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.com.google.common.base.Join;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.LocalEnvironment;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.UserCodeClasspathManager;
import com.google.appengine.tools.development.WebAppUserCodeClasspathManager;
import com.google.appengine.tools.info.SdkImplInfo;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.plugins.AppYamlProcessor;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import com.google.apphosting.utils.config.BackendsXml;
import com.google.apphosting.utils.config.BackendsXmlReader;
import com.google.apphosting.utils.config.WebXml;
import com.google.apphosting.utils.config.WebXmlReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public abstract class AbstractContainerService
implements ContainerService {
    private static final Logger log = Logger.getLogger(AbstractContainerService.class.getName());
    protected static final String _AH_URL_RELOAD = "/_ah/reloadwebapp";
    private static final String LOGGING_CONFIG_FILE = "java.util.logging.config.file";
    private static final String USER_CODE_CLASSPATH_MANAGER_PROP = "devappserver.userCodeClasspathManager";
    private static final String USER_CODE_CLASSPATH = "devappserver.userCodeClasspathManager.classpath";
    private static final String USER_CODE_REQUIRES_WEB_INF = "devappserver.userCodeClasspathManager.requiresWebInf";
    protected String devAppServerVersion;
    protected File appDir;
    protected File externalResourceDir;
    protected File webXmlLocation;
    protected String hostName;
    protected File appEngineWebXmlLocation;
    protected String address;
    protected int port;
    protected AppEngineWebXml appEngineWebXml;
    protected WebXml webXml;
    protected BackendsXml backendsXml;
    private static Properties originalSysProps = null;
    private static ContainerService.EnvironmentVariableMismatchSeverity envVarMismatchSeverity = ContainerService.EnvironmentVariableMismatchSeverity.ERROR;
    private CountDownLatch serverInitLatch;
    protected ApiProxyLocal apiProxyLocal;
    UserCodeClasspathManager userCodeClasspathManager;

    @Override
    public final LocalServerEnvironment configure(String devAppServerVersion, final File appDir, File externalResourceDir, File webXmlLocation, File appEngineWebXmlLocation, final String address, int port, Map<String, Object> containerConfigProperties) {
        this.devAppServerVersion = devAppServerVersion;
        this.appDir = appDir;
        this.externalResourceDir = externalResourceDir;
        this.webXmlLocation = webXmlLocation;
        this.appEngineWebXmlLocation = appEngineWebXmlLocation;
        this.address = address;
        this.port = port;
        this.serverInitLatch = new CountDownLatch(1);
        this.hostName = "localhost";
        if ("0.0.0.0".equals(address)) {
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                this.hostName = localhost.getHostName();
            }
            catch (UnknownHostException ex) {
                log.log(Level.WARNING, "Unable to determine hostname - defaulting to localhost.");
            }
        }
        this.userCodeClasspathManager = AbstractContainerService.newUserCodeClasspathProvider(containerConfigProperties);
        return new LocalServerEnvironment(){

            @Override
            public File getAppDir() {
                return appDir;
            }

            @Override
            public String getAddress() {
                return address;
            }

            @Override
            public String getHostName() {
                return AbstractContainerService.this.hostName;
            }

            @Override
            public int getPort() {
                return AbstractContainerService.this.port;
            }

            @Override
            public void waitForServerToStart() throws InterruptedException {
                AbstractContainerService.this.serverInitLatch.await();
            }

            @Override
            public boolean simulateProductionLatencies() {
                return false;
            }

            @Override
            public boolean enforceApiDeadlines() {
                return !Boolean.getBoolean("com.google.appengine.disable_api_deadlines");
            }
        };
    }

    private static UserCodeClasspathManager newUserCodeClasspathProvider(Map<String, Object> containerConfigProperties) {
        if (containerConfigProperties.containsKey(USER_CODE_CLASSPATH_MANAGER_PROP)) {
            final Map userCodeClasspathManagerProps = (Map)containerConfigProperties.get(USER_CODE_CLASSPATH_MANAGER_PROP);
            return new UserCodeClasspathManager(){

                @Override
                public Collection<URL> getUserCodeClasspath(File root) {
                    return (Collection)userCodeClasspathManagerProps.get(AbstractContainerService.USER_CODE_CLASSPATH);
                }

                @Override
                public boolean requiresWebInf() {
                    return (Boolean)userCodeClasspathManagerProps.get(AbstractContainerService.USER_CODE_REQUIRES_WEB_INF);
                }
            };
        }
        return new WebAppUserCodeClasspathManager();
    }

    @Override
    public final void startup() throws Exception {
        this.apiProxyLocal = (ApiProxyLocal)ApiProxy.getDelegate();
        File webAppDir = this.initContext();
        this.loadAppEngineWebXml(webAppDir);
        this.startContainer();
        this.startHotDeployScanner();
        this.serverInitLatch.countDown();
    }

    @Override
    public final void shutdown() throws Exception {
        this.stopHotDeployScanner();
        this.stopContainer();
        this.restoreSystemProperties();
    }

    @Override
    public Map<String, String> getServiceProperties() {
        return ImmutableMap.of("appengine.dev.inbound-services", Join.join(",", this.appEngineWebXml.getInboundServices()));
    }

    protected abstract File initContext() throws IOException;

    protected abstract void startContainer() throws Exception;

    protected abstract void stopContainer() throws Exception;

    protected abstract void startHotDeployScanner() throws Exception;

    protected abstract void stopHotDeployScanner() throws Exception;

    protected abstract void reloadWebApp() throws Exception;

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public AppEngineWebXml getAppEngineWebXmlConfig() {
        return this.appEngineWebXml;
    }

    @Override
    public BackendsXml getBackendsXml() {
        return this.backendsXml;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setEnvironmentVariableMismatchSeverity(ContainerService.EnvironmentVariableMismatchSeverity val) {
        envVarMismatchSeverity = val;
    }

    protected Permissions getUserPermissions() {
        return this.appEngineWebXml.getUserPermissions();
    }

    protected void loadAppEngineWebXml(File webAppDir) {
        AppEngineWebXmlReader appEngineWebXmlReader;
        WebXmlReader webXmlReader;
        if (this.webXmlLocation == null) {
            webXmlReader = new WebXmlReader(webAppDir.getAbsolutePath());
            this.webXmlLocation = new File(webXmlReader.getFilename());
        } else {
            webXmlReader = new WebXmlReader(this.webXmlLocation.getParent(), this.webXmlLocation.getName());
        }
        if (this.appEngineWebXmlLocation == null) {
            appEngineWebXmlReader = new AppEngineWebXmlReader(webAppDir.getAbsolutePath());
            this.appEngineWebXmlLocation = new File(appEngineWebXmlReader.getFilename());
        } else {
            appEngineWebXmlReader = new AppEngineWebXmlReader(this.appEngineWebXmlLocation.getParent(), this.appEngineWebXmlLocation.getName());
        }
        AppYamlProcessor.convert((File)new File(this.appDir, "WEB-INF"), (String)appEngineWebXmlReader.getFilename(), (String)this.webXmlLocation.getAbsolutePath());
        this.appEngineWebXml = appEngineWebXmlReader.readAppEngineWebXml();
        if (this.appEngineWebXml.getAppId() == null || this.appEngineWebXml.getAppId().length() == 0) {
            this.appEngineWebXml.setAppId("no_app_id");
        }
        this.webXml = webXmlReader.readWebXml();
        AbstractContainerService.staticInitialize(this.appEngineWebXml, this.appDir);
        this.webXml.validate();
        this.backendsXml = new BackendsXmlReader(webAppDir.getAbsolutePath()).readBackendsXml();
        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)new LocalInitializationEnvironment(this.appEngineWebXml.getAppId(), this.appEngineWebXml.getMajorVersionId()));
    }

    private static synchronized void staticInitialize(AppEngineWebXml appEngineWebXml, File appDir) {
        AbstractContainerService.setSystemProperties(appEngineWebXml);
        AbstractContainerService.checkEnvironmentVariables(appEngineWebXml);
        AbstractContainerService.updateLoggingConfiguration(originalSysProps, appEngineWebXml.getSystemProperties(), appDir);
    }

    protected void restoreSystemProperties() {
        for (String key : this.appEngineWebXml.getSystemProperties().keySet()) {
            System.clearProperty(key);
        }
        System.getProperties().putAll((Map<?, ?>)originalSysProps);
    }

    protected boolean isSessionsEnabled() {
        return this.appEngineWebXml.getSessionsEnabled();
    }

    protected URL[] getClassPathForApp(File root) {
        ArrayList<URL> appUrls = new ArrayList<URL>();
        appUrls.addAll(SdkImplInfo.getAgentRuntimeLibs());
        appUrls.addAll(this.userCodeClasspathManager.getUserCodeClasspath(root));
        for (URL url : SdkImplInfo.getUserJspLibs()) {
            appUrls.add(url);
        }
        for (URL url : SdkImplInfo.getWebApiToolLibs()) {
            appUrls.add(url);
        }
        return appUrls.toArray(new URL[appUrls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setSystemProperties(AppEngineWebXml appEngineWebXml) {
        SystemProperty.environment.set(SystemProperty.Environment.Value.Development);
        String release = SdkInfo.getLocalVersion().getRelease();
        if (release == null) {
            release = "null";
        }
        SystemProperty.version.set(release);
        SystemProperty.applicationId.set(appEngineWebXml.getAppId());
        SystemProperty.applicationVersion.set(appEngineWebXml.getMajorVersionId() + ".1");
        Class<AbstractContainerService> clazz = AbstractContainerService.class;
        synchronized (AbstractContainerService.class) {
            if (null == originalSysProps) {
                originalSysProps = new Properties();
                originalSysProps.putAll((Map<?, ?>)System.getProperties());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            System.getProperties().putAll(appEngineWebXml.getSystemProperties());
            return;
        }
    }

    private static void updateLoggingConfiguration(Properties systemProperties, Map<String, String> userSystemProperties, File appDir) {
        String userConfigFile = userSystemProperties.get(LOGGING_CONFIG_FILE);
        Properties userProperties = AbstractContainerService.loadPropertiesFile(userConfigFile, appDir);
        String sdkConfigFile = systemProperties.getProperty(LOGGING_CONFIG_FILE);
        Properties sdkProperties = AbstractContainerService.loadPropertiesFile(sdkConfigFile, appDir);
        Properties allProperties = new Properties();
        if (sdkProperties != null) {
            allProperties.putAll((Map<?, ?>)sdkProperties);
        }
        if (userProperties != null) {
            allProperties.putAll((Map<?, ?>)userProperties);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            allProperties.store(out, null);
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(out.toByteArray()));
            Logger root = Logger.getLogger("");
            ApiProxyLocal proxy = (ApiProxyLocal)ApiProxy.getDelegate();
            LocalLogService logService = (LocalLogService)proxy.getService("logservice");
            root.addHandler(logService.getLogHandler());
            Handler[] handlers = root.getHandlers();
            if (handlers != null) {
                for (Handler handler : handlers) {
                    handler.setLevel(Level.FINEST);
                }
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to configure logging properties.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFile(String file, File appDir) {
        if (file == null) {
            return null;
        }
        File f = new File(file = file.replace('/', File.separatorChar));
        if (!f.isAbsolute()) {
            f = new File(appDir + File.separator + f.getPath());
        }
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(f));
            Properties props = new Properties();
            props.load(inputStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to load properties file, " + f.getAbsolutePath(), e);
            Properties properties = null;
            return properties;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void checkEnvironmentVariables(AppEngineWebXml appEngineWebXml) {
        HashMap<String, String> missingEnvEntries = Maps.newHashMap();
        for (Map.Entry<String, String> entry : appEngineWebXml.getEnvironmentVariables().entrySet()) {
            if (entry.getValue().equals(System.getenv(entry.getKey()))) continue;
            missingEnvEntries.put(entry.getKey(), entry.getValue());
        }
        if (!missingEnvEntries.isEmpty()) {
            String msg = "One or more environment variables have been configured in appengine-web.xml that have missing or different values in your local environment. We recommend you use system properties instead, but if you are interacting with legacy code that requires specific environment variables to have specific values, please set these environment variables in your environment before running.\n" + Join.join("\n", missingEnvEntries, new Object[0]);
            if (envVarMismatchSeverity == ContainerService.EnvironmentVariableMismatchSeverity.WARNING) {
                log.warning(msg);
            } else if (envVarMismatchSeverity == ContainerService.EnvironmentVariableMismatchSeverity.ERROR) {
                throw new IncorrectEnvironmentVariableException(msg, missingEnvEntries);
            }
        }
    }

    protected static class LocalInitializationEnvironment
    extends LocalEnvironment {
        public LocalInitializationEnvironment(String appId, String majorVersionId) {
            super(appId, majorVersionId);
        }

        public String getEmail() {
            return null;
        }

        public boolean isLoggedIn() {
            return false;
        }

        public boolean isAdmin() {
            return false;
        }
    }

    static class IncorrectEnvironmentVariableException
    extends AppEngineConfigException {
        private final Map<String, String> missingEnvEntries;

        private IncorrectEnvironmentVariableException(String msg, Map<String, String> missingEnvEntries) {
            super(msg);
            this.missingEnvEntries = missingEnvEntries;
        }

        public Map<String, String> getMissingEnvEntries() {
            return this.missingEnvEntries;
        }
    }
}

