/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.info.SdkImplInfo;
import com.google.appengine.tools.info.SdkInfo;
import com.google.apphosting.utils.io.IoUtil;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.ReflectPermission;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.SecurityPermission;
import java.security.UnresolvedPermission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingPermission;

class IsolatedAppClassLoader
extends URLClassLoader {
    private static Logger logger = Logger.getLogger(IsolatedAppClassLoader.class.getName());
    private final PermissionCollection appPermissions;
    private final Permissions appPermissionsAsPermissions;
    private final ClassLoader devAppServerClassLoader;
    private final Set<URL> sharedCodeLibs;
    private final Set<URL> agentRuntimeLibs;

    public IsolatedAppClassLoader(File appRoot, File externalResourceDir, URL[] urls, ClassLoader devAppServerClassLoader) {
        super(urls, (ClassLoader)null);
        IsolatedAppClassLoader.checkWorkingDirectory(appRoot, externalResourceDir);
        this.appPermissions = this.createAppPermissions(appRoot, externalResourceDir);
        this.appPermissionsAsPermissions = new Permissions();
        IsolatedAppClassLoader.addAllPermissions(this.appPermissions, this.appPermissionsAsPermissions);
        this.installPolicyProxy(appRoot);
        this.devAppServerClassLoader = devAppServerClassLoader;
        this.sharedCodeLibs = new HashSet<URL>(SdkInfo.getSharedLibs());
        this.agentRuntimeLibs = new HashSet<URL>(SdkImplInfo.getAgentRuntimeLibs());
    }

    private static void checkWorkingDirectory(File appRoot, File externalResourceDir) {
        File workingDir = new File(System.getProperty("user.dir"));
        String canonicalWorkingDir = null;
        String canonicalAppRoot = null;
        String canonicalExternalResourceDir = null;
        try {
            canonicalWorkingDir = workingDir.getCanonicalPath();
            canonicalAppRoot = appRoot.getCanonicalPath();
            if (externalResourceDir != null) {
                canonicalExternalResourceDir = externalResourceDir.getCanonicalPath();
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Unable to compare the working directory and app root.", e);
        }
        if (canonicalWorkingDir != null && !canonicalWorkingDir.equals(canonicalAppRoot)) {
            if (canonicalExternalResourceDir != null && canonicalWorkingDir.equals(canonicalExternalResourceDir)) {
                return;
            }
            String newLine = System.getProperty("line.separator");
            String workDir = workingDir.getAbsolutePath();
            String appDir = appRoot.getAbsolutePath();
            String msg = "Your working directory, (" + workDir + ") is not equal to your " + newLine + "web application root (" + appDir + ")" + newLine + "You will not be able to access files from your working directory on the " + "production server." + newLine;
            logger.warning(msg);
        }
    }

    @Override
    public URL getResource(String name) {
        int bang;
        URL resource = this.devAppServerClassLoader.getResource(name);
        if (resource != null && resource.getProtocol().equals("jar") && (bang = resource.getPath().indexOf(33)) > 0) {
            try {
                URL url = new URL(resource.getPath().substring(0, bang));
                if (this.sharedCodeLibs.contains(url)) {
                    return resource;
                }
            }
            catch (MalformedURLException ex) {
                logger.log(Level.WARNING, "Unexpected exception while loading " + name, ex);
            }
        }
        return super.getResource(name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            final Class<?> c = this.devAppServerClassLoader.loadClass(name);
            CodeSource source = AccessController.doPrivileged(new PrivilegedAction<CodeSource>(){

                @Override
                public CodeSource run() {
                    return c.getProtectionDomain().getCodeSource();
                }
            });
            if (source == null) {
                return c;
            }
            URL location = source.getLocation();
            if (this.sharedCodeLibs.contains(location) || location.getFile().endsWith("/appengine-agent.jar")) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection permissions = super.getPermissions(codesource);
        if (this.agentRuntimeLibs.contains(codesource.getLocation())) {
            permissions.add(new AllPermission());
        } else {
            IsolatedAppClassLoader.addAllPermissions(this.appPermissions, permissions);
        }
        return permissions;
    }

    public Permissions getAppPermissions() {
        return this.appPermissionsAsPermissions;
    }

    private PermissionCollection createAppPermissions(File appRoot, File externalResourceDir) {
        Permissions permissions = new Permissions();
        ((PermissionCollection)permissions).add(new FilePermission(appRoot.getAbsolutePath() + File.separatorChar + "-", "read"));
        IsolatedAppClassLoader.addAllPermissions(IsolatedAppClassLoader.buildPermissionsToReadAppFiles(appRoot), permissions);
        if (externalResourceDir != null) {
            ((PermissionCollection)permissions).add(new FilePermission(externalResourceDir.getAbsolutePath() + File.separatorChar + "-", "read"));
            IsolatedAppClassLoader.addAllPermissions(IsolatedAppClassLoader.buildPermissionsToReadAppFiles(externalResourceDir), permissions);
        }
        if (Boolean.valueOf(System.getProperty("--enable_all_permissions")).booleanValue()) {
            ((PermissionCollection)permissions).add(new AllPermission());
            return permissions;
        }
        ((PermissionCollection)permissions).add(new RuntimePermission("getClassLoader"));
        ((PermissionCollection)permissions).add(new RuntimePermission("setContextClassLoader"));
        ((PermissionCollection)permissions).add(new RuntimePermission("createClassLoader"));
        ((PermissionCollection)permissions).add(new RuntimePermission("getProtectionDomain"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessDeclaredMembers"));
        ((PermissionCollection)permissions).add(new ReflectPermission("suppressAccessChecks"));
        ((PermissionCollection)permissions).add(new LoggingPermission("control", ""));
        ((PermissionCollection)permissions).add(new RuntimePermission("getStackTrace"));
        ((PermissionCollection)permissions).add(new RuntimePermission("getenv.*"));
        ((PermissionCollection)permissions).add(new RuntimePermission("setIO"));
        ((PermissionCollection)permissions).add(new PropertyPermission("*", "read,write"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.com.sun.xml.internal.ws.*"));
        ((PermissionCollection)permissions).add(new RuntimePermission("loadLibrary.keychain"));
        ((PermissionCollection)permissions).add(new UnresolvedPermission("javax.jdo.spi.JDOPermission", "getMetadata", null, null));
        ((PermissionCollection)permissions).add(new UnresolvedPermission("javax.jdo.spi.JDOPermission", "setStateManager", null, null));
        ((PermissionCollection)permissions).add(new UnresolvedPermission("javax.jdo.spi.JDOPermission", "manageMetadata", null, null));
        ((PermissionCollection)permissions).add(new UnresolvedPermission("javax.jdo.spi.JDOPermission", "closePersistenceManagerFactory", null, null));
        ((PermissionCollection)permissions).add(new UnresolvedPermission("groovy.security.GroovyCodeSourcePermission", "*", null, null));
        ((PermissionCollection)permissions).add(new FilePermission(System.getProperty("user.dir") + File.separatorChar + "-", "read"));
        ((PermissionCollection)permissions).add(IsolatedAppClassLoader.getJreReadPermission());
        for (File f : SdkInfo.getSharedLibFiles()) {
            ((PermissionCollection)permissions).add(new FilePermission(f.getAbsolutePath(), "read"));
        }
        ((PermissionCollection)permissions).add(new SecurityPermission("putProviderProperty.*"));
        ((PermissionCollection)permissions).add(new SecurityPermission("insertProvider.*"));
        ((PermissionCollection)permissions).add(new SecurityPermission("removeProvider.*"));
        permissions.setReadOnly();
        return permissions;
    }

    private void installPolicyProxy(File appRoot) {
        Policy p = Policy.getPolicy();
        if (p instanceof ProxyPolicy) {
            return;
        }
        Policy.setPolicy(new ProxyPolicy(p, appRoot));
    }

    private static PermissionCollection buildPermissionsToReadAppFiles(File contextRoot) {
        Permissions permissions = new Permissions();
        String path = contextRoot.getAbsolutePath();
        ((PermissionCollection)permissions).add(new FilePermission(path, "read"));
        ((PermissionCollection)permissions).add(new FilePermission(path + "/-", "read"));
        List<File> allFiles = IoUtil.getFilesAndDirectories(contextRoot);
        for (File file : allFiles) {
            String filePath = file.getAbsolutePath();
            ((PermissionCollection)permissions).add(new FilePermission(filePath, "read"));
        }
        permissions.setReadOnly();
        return permissions;
    }

    private static Permission getReadPermission(URL url) {
        Permission p;
        try {
            URLConnection urlConnection = url.openConnection();
            p = urlConnection.getPermission();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to obtain the permission for " + url, e);
        }
        return new FilePermission(p.getName(), "read");
    }

    private static Permission getJreReadPermission() {
        return IsolatedAppClassLoader.getReadPermission(Object.class.getResource("/java/lang/Object.class"));
    }

    private static void addAllPermissions(PermissionCollection src, PermissionCollection dest) {
        Enumeration<Permission> srcElements = src.elements();
        while (srcElements.hasMoreElements()) {
            dest.add(srcElements.nextElement());
        }
    }

    class ProxyPolicy
    extends Policy {
        private Policy delegate;
        private File appRoot;

        ProxyPolicy(Policy delegate, File appRoot) {
            this.delegate = delegate;
            this.appRoot = appRoot;
        }

        @Override
        public Provider getProvider() {
            return this.delegate.getProvider();
        }

        @Override
        public String getType() {
            return this.delegate.getType();
        }

        @Override
        public Policy.Parameters getParameters() {
            return this.delegate.getParameters();
        }

        @Override
        public PermissionCollection getPermissions(final CodeSource codeSource) {
            return AccessController.doPrivileged(new PrivilegedAction<PermissionCollection>(){

                @Override
                public PermissionCollection run() {
                    PermissionCollection delegatePerms = ProxyPolicy.this.delegate.getPermissions(codeSource);
                    try {
                        if (ProxyPolicy.this.appRoot.toURL().equals(codeSource.getLocation())) {
                            Permissions newPerms = new Permissions();
                            IsolatedAppClassLoader.addAllPermissions(delegatePerms, newPerms);
                            IsolatedAppClassLoader.addAllPermissions(IsolatedAppClassLoader.this.appPermissions, newPerms);
                            return newPerms;
                        }
                    }
                    catch (MalformedURLException ex) {
                        throw new RuntimeException("Could not turn " + ProxyPolicy.this.appRoot + "into a URL", ex);
                    }
                    return delegatePerms;
                }
            });
        }

        @Override
        public PermissionCollection getPermissions(ProtectionDomain domain) {
            return this.getPermissions(domain.getCodeSource());
        }

        @Override
        public boolean implies(final ProtectionDomain domain, final Permission permission) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return ProxyPolicy.this.delegate.implies(domain, permission);
                }
            });
        }

        @Override
        public void refresh() {
            this.delegate.refresh();
        }
    }
}

