(ns gws.balanced.api.cards
  (:refer-clojure :exclude [get])
  (:require [gws.balanced.client :as client]))

(defn get
  [client id]
  (let [path (format "/cards/%s" id)]
    (client/call client :get path)))

(defn assoc-customer!
  [client card-id customer-id]
  (let [card-path (format "/cards/%s" card-id)
        customer-path (format "/customers/%s" customer-id)]
    (client/call client :put card-path {:customer customer-path})))
