# persona

A Clojure library for consuming the
[Mozilla Persona](https://developer.mozilla.org/en-US/Persona)
API.

## Usage

Available on [Clojars](http://clojars.org/gws/persona).

```clojure
[gws/persona "0.1.0"]
```

```clojure
(ns your.app
  (:require [gws.persona.verifier :as verifier]))

(let [assertion "Assertion string you got from the client"
      audience "http://localhost:8080"
      result (verifier/verify assertion audience)
      valid? (verifier/valid? result)]
  (println (str "Result: " result))
  (println (str "Valid? " valid?)))
```

## Features

Currently, only the
[Remote Verification API](https://developer.mozilla.org/en-US/Persona/Remote_Verification_API)
is implemented, but that may be all you need.

## Testing

```sh
lein test
```

## License

Copyright © 2014 Gordon Stratton

Distributed under the [ISC License](http://opensource.org/licenses/ISC)
