(ns hara.core.component
  (:require [hara.module :as module]
            [hara.core.component.common :as common]
            [hara.core.component.array :as array]
            [hara.core.component.system :as system]
            [hara.core.component.partial :as partial]
            [hara.core.component.display :as display]))

(defn component-wrap-fn
  "TODO"
  {:added "3.0"}
  ([{:keys [name]}]
   (symbol "hara.core.component" (subs (clojure.core/name name) 1))))

(module/include

 (hara.core.component.common  component?
                              system?
                              start
                              stop
                              kill
                              started?
                              stopped?
                              remote?
                              health
                              info
                              get-prop
                              set-prop
                              with)

 (hara.core.component.array   array?
                              array)

 (hara.core.component.system  system)
 
 (hara.core.component.partial valid-subcomponents
                              subsystem
                              wait
                              wait-for))
