(ns hara.data
  (:require [hara.module :as module]
            [hara.data.base.combine]
            [hara.data.base.complex]
            [hara.data.base.diff]
            [hara.data.base.map]
            [hara.data.base.nested]
            [hara.data.base.seq]))

(module/include

 (hara.data.base.combine   combine
                           decombine)

 (hara.data.base.complex   assocs
                           dissocs
                           gets
                           merges
                           merges-nested
                           gets-in
                           dissocs-in)

 (hara.data.base.diff      diff
                           changed
                           patch
                           unpatch)

 (hara.data.base.map       dissoc-in
                           transform-in
                           retract-in
                           unique
                           
                           assoc-nnil
                           assoc-in-nnil
                           update-in-nnil
                           merge-nnil
                           into-nnil
                           select-keys-nnil
                           
                           merge-new
                           assoc-in-new
                           assoc-new
                           keep-vals
                           transpose)
                          
 (hara.data.base.nested    keys-nested
                           key-paths
                           update-keys-in
                           update-vals-in
                           merge-nested
                           merge-new-nested
                           dissoc-nested
                           unique-nested
                           clean-nested)
                          
 (hara.data.base.seq       positions
                           remove-index
                           index-of
                           element-of
                           flatten-all))
