(ns hara.io.concurrent
  (:require [hara.core.base.thread :as thread]
            [hara.io.concurrent.executor :as executor]
            [hara.io.concurrent.queue :as queue]
            [hara.io.concurrent.parallel :as parallel]
            [hara.io.concurrent.common :as common]
            [hara.module :as module])
  (:refer-clojure :exclude [take pop map take-last peek remove]))

(module/include

 (hara.core.base.thread     interrupt
                            current-thread
                            [thread-wait-on wait-on]
                            [thread-wait-spin wait-spin]
                            [thread-notify notify]
                            [thread-notify-all notify-all]
                            daemon?
                            thread-id
                            all-stacktraces
                            all-threads
                            all-thread-ids
                            [thread-interrupted? interrupted?]
                            [thread-has-lock? has-lock?]
                            [thread-alive? alive?]
                            [thread-accessible? has-access?]
                            sleep
                            thread
                            [thread-join join]
                            [thread-yield yield]
                            [thread-run run]
                            [thread-start start]
                            [thread-dump dump])

 (hara.io.concurrent.parallel fork
                              join)
 
 (hara.io.concurrent.common map
                            return
                            return?
                            returned
                            fulfil)

 (hara.io.concurrent.queue deque
                           queue
                           queue?
                           deque?
                           fixed-queue
                           limited-queue
                           take
                           drain
                           put
                           peek
                           remaining-capacity
                           peek-first
                           peek-last
                           put-first
                           put-last
                           take-first
                           take-last
                           push
                           pop
                           remove
                           process-bulk
                           process-atom-queue)

 (hara.io.concurrent.executor raw-queue
                              single-executor
                              pool-executor
                              cached-executor
                              shutdown
                              shutdown-now
                              get-queue
                              wrap-min-time
                              submit
                              submit-notify
                              scheduled-executor
                              schedule
                              schedule-fixed-rate
                              schedule-fixed-delay
                              await-termination
                              shutdown?
                              terminated?
                              terminating?
                              current-size
                              current-active
                              current-submitted
                              current-completed
                              pool-size
                              set-pool-size
                              pool-max
                              set-pool-max
                              keep-alive
                              set-keep-alive
                              set-rejected-handler
                              at-capacity?
                              increase-capacity
                              raw-executor-type
                              raw-executor-info
                              raw-executor-props
                              raw-executor
                              pool-size
                              tracked-executors
                              active-executors))

