(ns hara.io.concurrent.common
  (:import (java.util.concurrent ConcurrentHashMap))
  (:refer-clojure :exclude [map]))

(defn ^ConcurrentHashMap map
  "constructs a concurrent hash map
 
   (cc/map :a 1 :b 2)
   => java.util.concurrent.ConcurrentHashMap"
  {:added "3.0"}
  ([]
   (ConcurrentHashMap.))
  ([& elements]
   (ConcurrentHashMap. ^java.util.Map (apply hash-map elements))))

(deftype Return [promise]
 Object
 (toString [ret] (str "#wrap." (subs (pr-str promise) 1)))

 clojure.lang.IDeref
 (deref [m]
   (let [{:keys [status data exception]} @promise]
     (case status
       :success data
       :error (throw exception)
       :interrupted (throw (InterruptedException.))))))

(defmethod print-method Return
 ([v ^java.io.Writer w]
  (.write w (str v))))

(defn return
  "wrapper for a promise with status
 
   (cc/return)
   => hara.io.concurrent.common.Return"
  {:added "3.0"}
  ([]
   (Return. (promise))))

(defn returned
  "returns the actual promise
 
   (cc/returned (cc/return))
   => clojure.lang.IDeref"
  {:added "3.0"}
  ([^Return return]
   (.promise return)))

(defn return?
  "checks if object is instance of `Return`
 
   (cc/return? (cc/return))
   => true"
  {:added "3.0"}
  ([obj]
   (instance? Return obj)))

(defn fulfil
  "fulfils the return with a function
 
   (cc/fulfil (cc/return) (fn [] (+ 1 2 3)))
   
   (cc/fulfil (cc/return) (fn [] (throw (ex-info \"Hello\" {}))))"
  {:added "3.0"}
  ([^Return return f]
   (fulfil return f false))
  ([^Return return f print]
   (let [[status data exception] (try
                                   [:success (f) nil]
                                   (catch Throwable t
                                     (if print (.printStackTrace t))
                                     [:error nil t]))]
     (deliver (returned return) {:status status
                                 :data data
                                 :exception exception}))))
