(ns hara.io.concurrent.parallel
  (:import (java.util.concurrent ForkJoinPool
                                 ForkJoinWorkerThread
                                 ForkJoinTask
                                 RecursiveTask)))

(defonce ^:dynamic ^ForkJoinPool
  *pool* (ForkJoinPool/commonPool))

(defn task
  "creates a task for the fork/join pool
 
   (task (fn [] (+ 1 2 3)))"
  {:added "3.0"} [f]
  (proxy [RecursiveTask] []
    (compute ([] (f)))))

(defn execute
  "executes a task
 
   (-> (task (fn [] (+ 1 2 3)))
       (execute)
       (deref))
   => 6"
  {:added "3.0"}
  ([^ForkJoinTask task]
   (if (ForkJoinTask/inForkJoinPool)
     (.fork task)
     (.execute *pool* task))
   task))

(defmacro fork
  "runs the statement as a task
 
   @(run (+ 1 2 3))
   => 6"
  {:added "3.0"}
  [& body]
  `(execute (task (fn [] ~@body))))

(defn join
  "calls join on the thread
 
   (join (run (+ 1 2 3)))
   => 6"
  {:added "3.0"}
  ([^ForkJoinTask task]
   (.join task)))
