(ns hara.function
  (:require [hara.module :as module]
            [hara.function.base.native])
  (:refer-clojure :exclude [memoize]))

(module/include
 
 (hara.function.base.arg          arg-check
                                  arg-count
                                  varg-count
                                  vargs?)
 
 (hara.function.base.dispatch     invoke
                                  call
                                  message 
                                  op)
 
 (hara.function.base.executive    defexecutive)
 
 (hara.function.base.form         form-fn
                                  form-eval
                                  form-apply)
 
 (hara.function.base.hook         list-patched
                                  patch
                                  patched?
                                  unpatch)

 (hara.function.base.invoke       definvoke
                                  form-arglists
                                  fn)
 
 (hara.function.base.macro        const
                                  applym
                                  create-args
                                  create-def-form
                                  defcompose
                                  lookup
                                  deflookup)
 
 (hara.function.base.memoize      memoize
                                  memoize-clear
                                  memoize-remove
                                  defmemoize)
 
 (hara.function.base.multi        multi?
                                  multi-clone
                                  multi-keys
                                  multi-has?
                                  multi-list
                                  multi-get
                                  multi-remove
                                  multi-match?
                                  multi-add))
