(ns hara.config
  (:require [hara.module :as module]
            [hara.config.base.resolve]
            [hara.config.base.global]
            [hara.config.base.secure])
  (:refer-clojure :exclude [resolve load]))

(module/include
 
 (hara.config.base.resolve      resolve
                                load)
 
 (hara.config.base.global       global)

 (hara.config.base.secure       resolve-key
                                encrypt-text
                                decrypt-text))

(def +directives+
  [:format
   :str
   :or
   :case
   :error
   :eval

   :merge
   :root
   :parent
   
   :global
   :properties
   :env
   :project

   :include
   :file
   :resource])

(def +opt-keys+
  [:type
   :secured
   :key
   :default])

(def +opt-types+
  [;; builtin
   :text
   :edn
   :key
   
   ;; extensions
   :gpg.public
   :gpg
   :yaml
   :json])

