(ns hara.config
  (:require [hara.module :as module]))

(module/include

 (hara.config.base.resolve      resolve
                                load)
 
 (hara.config.base.global       global))

(def +directives+
  [:format
   :str
   :or
   :case
   :error
   :eval

   :merge
   :root
   :parent
   
   :global
   :properties
   :env
   :project

   :include
   :file
   :resource])

(def +opt-keys+
  [:type
   :secured
   :key
   :default])

(def +opt-types+
  [;; builtin
   :text
   :edn
   :key
   
   ;; extensions
   :gpg.public
   :gpg
   :yaml
   :json])

