/*
 * Decompiled with CFR 0.152.
 */
package hara.lib.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class DateSerializer
extends StdSerializer<Date> {
    private final SimpleDateFormat formatter;

    public DateSerializer(String string) {
        super(DateSerializer.class, true);
        this.formatter = new SimpleDateFormat(string);
        this.formatter.setTimeZone(new SimpleTimeZone(0, "UTC"));
    }

    public DateSerializer() {
        this("yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        SimpleDateFormat simpleDateFormat = this.formatter;
        synchronized (simpleDateFormat) {
            jsonGenerator.writeString(this.formatter.format(date));
        }
    }
}

