(ns hara.lib.undertow.exchange
  (:require [hara.object :as object])
  (:import (io.undertow.server HttpHandler HttpServerExchange)))

(sort (keys (object/write-setters HttpServerExchange)))

(:destination-address :dispatch-executor :max-entity-size :persistent :protocol :query-string :reason-phrase :relative-path
                      :request-method :request-path :request-scheme :request-uri
                      :resolved-path
                      :response-code :response-content-length :response-cookie
                      :security-context :source-address :status-code)

(sort (keys (object/read-getters HttpServerExchange)))
(:connection :destination-address :dispatch-executor :host-and-port :host-name :host-port :input-stream :io-thread :max-entity-size :output-stream :path-parameters :protocol :query-parameters :query-string :reason-phrase :relative-path

             :request-channel :request-charset :request-content-length
             :request-cookies :request-headers :request-method :request-path
             :request-receiver :request-scheme :request-start-time :request-uri :request-url

             :resolved-path
             
             :response-bytes-sent :response-channel :response-charset :response-code :response-content-length :response-cookies :response-headers :response-sender
             :security-context :source-address :status-code)
