(ns hara.object
  (:require [hara.module :as module]
            [hara.object.element]
            [hara.object.query]
            [hara.object.framework])
  (:refer-clojure :exclude [get get-in set keys instance?]))

(module/include

 (hara.object.element.common          element?
                                      element
                                      context-class)
 (hara.object.element.class           class-convert)
 
 (hara.object.element                 to-element
                                      class-info
                                      class-hierarchy
                                      constructor?
                                      method?
                                      field?
                                      static?
                                      instance?
                                      public?
                                      private?
                                      plain?)
 
 (hara.object.query                   query-class
                                      query-instance
                                      query-hierarchy
                                      delegate)

 
 (hara.object.framework.access        get
                                      get-in
                                      set
                                      keys
                                      meta-clear)
 
 (hara.object.framework.read          meta-read
                                      meta-read-exact
                                      meta-read-exact?
                                      to-data
                                      to-map
                                      read-ex
                                      read-getters
                                      read-all-getters
                                      read-fields)
 
 (hara.object.framework.struct        struct-fields
                                      struct-getters
                                      struct-accessor)
 
 (hara.object.framework.write         meta-write
                                      meta-write-exact
                                      meta-write-exact?
                                      from-data
                                      write-ex
                                      write-setters
                                      write-all-setters
                                      write-fields)
 
 (hara.object.framework               vector-like
                                      map-like
                                      string-like
                                      unextend))
