(ns hara.platform.mail.interop.recipient
  (:require [hara.object :as object]
            [hara.object.query :as reflect])
  (:import [javax.mail Message$RecipientType]
           [javax.mail.internet MimeMessage$RecipientType])
  (:refer-clojure :exclude [list]))

(def construct (reflect/query-class MimeMessage$RecipientType ["new" :#]))

(object/string-like
 Message$RecipientType
 {:tag  "recipient"
  :read  str
  :write construct})

(def list {:to  MimeMessage$RecipientType/TO
           :cc  MimeMessage$RecipientType/CC
           :bcc MimeMessage$RecipientType/BCC})
