(ns hara.platform.mail.local
  (:require [hara.protocol.mail :as protocol.mail]
            [hara.string :as string]
            [hara.object :as object]
            [hara.platform.mail.interop.message :as message])
  (:import )
  (:refer-clojure :exclude [send]))

(defn sendmail-cmd
  "finds path to the sendmail program
 
   (sendmail-cmd)
   ;;=> \"/usr/sbin/sendmail\"
   "
  {:added "3.0"}
  []
  (-> (ProcessBuilder. ["which" "sendmail"])
      (.start)
      (.getInputStream)
      (slurp)
      (string/trim-newlines)))

(defn send
  "sends an email using local smtp provider
 
   (send {:from \"z@z.com\"
          :to [\"z@z.com\"]
         :subject (str \"Hello There - \" (rand))
          :body [{:type :inline
                  :text \"Here is the attachment\\n\\n\"}
                 {:type :attachment
                  :description \"hello there\"
                  :file \"project.clj\"}]})"
  {:added "3.0"}
  [{:keys [from to subject body] :as message}]
  (let [m   (message/message message)
        all (object/to-data (object/get m :all-recipients))
        p   (.start (ProcessBuilder. ^"[Ljava.lang.String;" (concat [(sendmail-cmd) "-f" from]
                                                                    all)))
        out (.getOutputStream p)]
   (.writeTo m out)
   (.close out)
   (.waitFor p)
   (.exitValue p)))

(defrecord LocalMailer []
  Object
  (toString [_]
    (str "#mailer.local" {}))

  protocol.mail/IMailer
  (-send-mail [_ message]
    (send message)))

(defmethod print-method LocalMailer
  [v ^java.io.Writer w]
  (.write w (str v)))

(defmethod protocol.mail/-create-mailer :local
  [_]
  (LocalMailer.))
