(ns hara.platform.server.params
  "Middleware to parse url-encoded parameters from the query string and request
  body."
  (:require [ring.util.codec :as codec]
            [ring.util.request :as req]))

(defn- parse-params [params encoding]
  (let [params (codec/form-decode params encoding)]
    (if (map? params) params {})))

(defn assoc-query-params
  "Parse and assoc parameters from the query string with the request"
  {:added "1.0"}
  [request encoding]
  (merge-with merge request
    (if-let [query-string (:query-string request)]
      (let [params (parse-params query-string encoding)]
        {:query-params params, :params params})
      {:query-params {}, :params {}})))

(defn params-request
  "Adds parameters from the query string and the request body to the request map"
  {:added "1.0"}
  [request & [opts]]
  (let [encoding (or (:encoding opts)
                     (req/character-encoding request)
                     "UTF-8")]
    (if (:query-params request)
      request
      (assoc-query-params request encoding))))

(defn wrap-params
  "Middleware to parse urlencoded parameters from the query string and form
   body (if the request is a url-encoded form). Adds the following keys to
   the request map:
 
   :query-params - a map of parameters from the query string
   :form-params  - a map of parameters from the body
   :params       - a merged map of all types of parameter
 
   Accepts the following options:      
 
   :encoding - encoding to use for url-decoding. If not specified, uses
               the request character encoding, or \"UTF-8\" if no request
               character encoding is set."
  {:added "1.0"}
  [handler & [options]]
  (fn [request]
    (handler (params-request request options))))
