(ns hara.platform.storage
  (:require [hara.platform.storage.mock :as mock]
            [hara.platform.storage.file :as file]
            [hara.protocol.storage :as protocol.storage]
            [hara.core.component :as component])
  (:refer-clojure :exclude [list read]))

(defn write
  "writes a key to store
 
   (-> (storage/storage -mock-conf-)
       (storage/write \"foo\" \"Bar Baz\")
       (storage/list))
   => (contains [\"hello\" \"sample\" \"foo\"] :in-any-order)"
  {:added "0.1"}
  ([storage key bytes]
   (protocol.storage/-write storage key bytes)))

(defn read
  "reads from a given key
 
   (-> (storage/storage -mock-conf-)
       (storage/read \"hello\")
       slurp)
   => \"Hello World\""
  {:added "0.1"}
  ([storage key]
   (protocol.storage/-read storage key)))

(defn list
  "lists all keys in the store
 
   (-> (storage/storage -mock-conf-)
       (storage/list))
   => (contains [\"hello\" \"sample\"] :in-any-order)"
  {:added "0.1"}
  ([storage]
   (protocol.storage/-list storage)))

(defn info
  "gets info for a given key
 
   (-> (storage/storage -mock-conf-)
       (storage/info \"hello\"))
   => (contains {:size 11})"
  {:added "0.1"}
  ([storage key]
   (protocol.storage/-info storage key)))

(defn clear
  "clears data from storage
 
   (-> (storage/storage -mock-conf-)
       (storage/clear)
       (storage/list))
   => nil"
  {:added "0.1"}
  ([storage]
   (protocol.storage/-clear storage))
  ([storage key]
   (protocol.storage/-clear storage key)))

(defn create
  "creates an uninitialised storage
 
   (component/with [storage (storage/create -mock-conf-)]
     (storage/list storage))
   => [\"hello\" \"sample\"]"
  {:added "0.1"}
  ([m]
   (protocol.storage/-create m)))

(defn storage
  "creates a storage
 
   (storage/storage -mock-conf-)"
  {:added "0.1"}
  ([m]
   (-> (create m)
       (component/start))))

(defn storage?
  "checks if instance is a storage type
 
   (storage/storage? (storage/storage -mock-conf-))
   => true"
  {:added "0.1"}
  ([obj]
   (satisfies? protocol.storage/IStorage obj)))
