(ns hara.platform.local)

(defn local-host
  "returns the current host
   
   (local-host)
   ;; #object[java.net.Inet4Address 0x4523dee \"chapterhouse.local/127.0.0.1\"]
   => java.net.Inet4Address"
  {:added "3.0"}
  []
  (java.net.InetAddress/getLocalHost))

(defn local-ip
  "returns the current ip
 
   (local-ip)
   ;; \"127.0.0.1\"
   => string?"
  {:added "3.0"}
  []
  "Get the IP address for the machine that this JVM is running on.
  Uses the `java.net.InetAddress` method `getHostAddress`."
  (.getHostAddress (local-host)))

(defn local-hostname
  "returns the current host name
 
   (local-hostname)
   ;; \"chapterhouse.local\"
   => string?"
  {:added "3.0"}
  []
  (.getHostName (local-host)))

(defn local-shortname
  "returns the current host short name
 
   (local-shortname)
   ;; \"chapterhouse\"
   => string?"
  {:added "3.0"}
  []
  (-> (local-hostname)
      (clojure.string/split #"\.")
      first))
