(ns hara.publish.link.api
  (:require [hara.code.framework.docstring :as docstring]
            [hara.io.file :as fs]))

(defn external-vars
  "grabs external vars from the `module/include` form
 
   (external-vars (project/file-lookup (project/project))
                  'hara.test)
   => '{hara.test.checker.base [throws exactly satisfies anything]
        hara.test.checker.collection [contains just contains-in just-in throws-info]
        hara.test.checker.logic [any all is-not]
        hara.test.form [fact facts =>]}"
  {:added "3.0"}
  [lookup ns]
  (if-let [path (lookup ns)]
    (->> (fs/code path)
         (filter #(-> % first (= 'module/include)))
         (mapcat #(->> % rest))
         (map (juxt first rest))
         (into {}))))

(defn create-api-table
  "creates a api table for publishing"
  {:added "3.0"}
  [references project namespace]
  (let [lookup  (:lookup project)
        all-vars (-> (external-vars lookup namespace)
                     (assoc namespace :all))
        live-vars (do (require namespace)
                      (ns-interns namespace))]
    (reduce-kv (fn [table ns vals]
                 (let [relative-to-root #(if % (->> % (fs/relativize (:root project)) str))
                       vals (if (= :all vals)
                              (-> ns references keys)
                              vals)]
                   (reduce (fn [out v]
                             (let [entry (-> (get-in references [ns v])
                                             (update-in [:test :code] docstring/->refstring)
                                             (update-in [:test :path] relative-to-root)
                                             (update-in [:source :path] relative-to-root)
                                             (assoc :origin (symbol (str ns "/" v))
                                                    :arglists (-> (get live-vars v)
                                                                  meta
                                                                  :arglists)))]
                               (assoc out v entry)))
                           table
                           vals)))
               {}
               all-vars)))

(defn link-apis
  "links all the api source and test files to the elements"
  {:added "3.0"}
  [{:keys [references project] :as interim} name]
  (update-in interim [:articles name :elements]
             (fn [elements]
               (mapv (fn [{:keys [type namespace] :as element}]
                       (if (= type :api)
                         (-> element
                             (assoc :project project)
                             (assoc :table
                                    (create-api-table references
                                                      project
                                                      (symbol namespace))))
                         element))
                     elements))))
