(ns hara.publish.collect.reference
  (:require [hara.code.framework :as code.base]
            [hara.data.base.nested :as nested]
            [hara.io.file :as fs]))

(defn find-import-namespaces
  "finds forms with `(module/include ...)`
 
   (find-import-namespaces (project/file-lookup (project/project))
                           'hara.test)
   => '(hara.test.checker.base
        hara.test.checker.collection
        hara.test.checker.logic
        hara.test.form)"
  {:added "3.0"}
  [lookup ns]
  (if-let [path (lookup ns)]
    (->> (fs/read-code path)
         (filter #(-> % first (= 'module/include)))
         (mapcat #(->> % rest (map first))))))

(defn reference-namespaces
  "finds the referenced vars in the namespace
 
   (-> (reference-namespaces {}
                             (project/file-lookup (project/project))
                             '[hara.module.artifact.common])
       (get 'hara.module.artifact.common)
       keys
       sort)
   => '(resource-entry resource-entry-symbol)"
  {:added "3.0"}
  [references lookup namespaces]
  (let [missing   (remove references namespaces)
        imported  (->> missing
                       (mapcat #(find-import-namespaces lookup %))
                       (remove references))
        sources   (concat missing imported)
        tests     (map #(symbol (str % "-test")) sources)]
    (reduce (fn [references ns]
              (if-let [file (lookup ns)]
                (->> (code.base/analyse-file file)
                     (nested/merge-nested references))
                references))
            references
            (concat sources tests))))

(defn collect-references
  "collects all `:reference` tags of within an article
 
   (let [project (project/project)
         project (assoc project :lookup (project/file-lookup project))
         elems   (parse/parse-file \"test/documentation/hara/hara_publish.clj\" project)
         bundle  {:articles {\"hara.publish\" {:elements elems}}
                  :references {}
                  :project project}]
     (-> (collect-references bundle \"hara.publish\")
         :references
        keys))
   => '(hara.publish.parse)"
  {:added "3.0"}
  [{:keys [articles project] :as interim} name]
  (let [all    (->> (get-in articles [name :elements])
                    (filter #(-> % :type (= :reference))))
        namespaces (-> (map (comp symbol namespace symbol :refer) all))]
    (-> interim
        (update-in [:references]
                   (fnil (fn [references]
                           (reference-namespaces references
                                                 (:lookup project)
                                                 namespaces))
                         {})))))
