(ns hara.string.mustache
  (:require [hara.data.base.tree :as data]
            [hara.string.base.common :as common])
  (:import (hara.string.mustache Context Mustache)))

(defn render
  "converts a template with mustache data
 
   (render \"{{user.name}}\" {:user {:name \"hara\"}})
   => \"hara\"
 
   (render \"{{# user.account}}{{name}} {{/user.account}}\"
           {:user {:account [{:name \"admin\"}
                             {:name \"user\"}]}})
   => \"admin user \"
 
   (render \"{{? user}}hello{{/user}}\" {:user true})
   => \"hello\"
 
   (render \"{{^ user.name}}hello{{/user.name}}\" {:user nil})
   => \"hello\""
  {:added "3.0"}
  [template data]
  (if (empty? template)
    template
    (let [template (Mustache/preprocess template)
          flattened (data/flatten-keys-nested data -1 false ".")]
      (.render template (Context. flattened nil)))))
