(ns leiningen.new.hc-admin
  (:require [leiningen.new.templates :refer [multi-segment sanitize-ns renderer name-to-path ->files]]
            [leiningen.core.main :as main]
            [clojure.java.io :as io]))

(def core-assets
  [[".gitignore" "gitignore"]
   ["dev-config.edn" "dev-config.edn"]
   ["test-config.edn" "test-config.edn"]
   ["Procfile" "Procfile"]
   ["Dockerfile" "Dockerfile"]
   ["Capstanfile" "Capstanfile"]
   ["README.md" "README.md"]
   ["shadow-cljs.edn" "shadow-cljs.edn"]
   ["package.json" "package.json"]
   ["env/prod/resources/config.edn" "env/prod/resources/config.edn"]
   ["env/dev/resources/config.edn" "env/dev/resources/config.edn"]
   ["env/test/resources/config.edn" "env/dev/resources/config.edn"]

   ;; config namespaces
   
   ["env/dev/clj/{{sanitized}}/env.clj" "env/dev/clj/env.clj"]
   ["env/dev/clj/{{sanitized}}/dev_middleware.clj" "env/dev/clj/dev_middleware.clj"]
   ["env/dev/cljs/{{sanitized}}/app.cljs" "env/dev/cljs/app.cljs"]
   ["env/prod/clj/{{sanitized}}/env.clj" "env/prod/clj/env.clj"]
   ["env/prod/clj/{{sanitized}}/app.cljs" "env/prod/cljs/app.cljs"]

   ;; core namespaces
   ["env/dev/clj/user.clj" "env/dev/clj/user.clj"]
   ["{{backend-path}}/{{sanitized}}/core.clj" "src/clj/core.clj"]
   ["{{backend-path}}/{{sanitized}}/nrepl.clj" "src/clj/nrepl.clj"]
   ["{{backend-path}}/{{sanitized}}/config.clj" "src/clj/config.clj"]
   ["{{backend-path}}/{{sanitized}}/handler.clj" "src/clj/handler.clj"]
   ["{{backend-path}}/{{sanitized}}/layout.clj" "src/clj/layout.clj"]
   ["{{backend-path}}/{{sanitized}}/middleware.clj" "src/clj/middleware.clj"]
   ["{{backend-path}}/{{sanitized}}/middleware/formats.clj" "src/clj/middleware/formats.clj"]
   ["{{backend-path}}/{{sanitized}}/middleware/exception.clj" "src/clj/middleware/exception.clj"]
   ["{{backend-path}}/{{sanitized}}/db/core.clj" "src/clj/db/core.clj"]
   ["{{backend-path}}/{{sanitized}}/routes/services.clj" "src/clj/routes/services.clj"]

      ;;HTML templates
   ["{{resource-path}}/migrations/20190831145908-add-users-table.down.sql" "resources/migrations/20190831145908-add-users-table.down.sql"]
   ["{{resource-path}}/migrations/20190831145908-add-users-table.up.sql" "resources/migrations/20190831145908-add-users-table.up.sql"]
   ["{{resource-path}}/sql/queries.sql" "resources/sql/queries.sql"]
   
   ["{{resource-path}}/public/favicon.ico" "resources/favicon.ico"]
   ["{{resource-path}}/public/index.html" "resources/public/index.html"]
   ["{{resource-path}}/public/img/warning_clojure.png" "resources/img/warning_clojure.png"]  

   ;; public resources, example URL: /css/screen.css
   ["{{resource-path}}/public/css/screen.css" "resources/css/screen.css"]
   "{{resource-path}}/public/js"

   ;; tests
   ["{{backend-test-path}}/{{sanitized}}/test/handler.clj" "test/clj/handler.clj"]
   ["{{backend-test-path}}/{{sanitized}}/test/db/core.clj" "test/clj/db/core.clj"]

   ;; cljs
   ["{{client-path}}/{{sanitized}}/ajax.cljs" "src/cljs/ajax.cljs"]
   ["{{client-path}}/{{sanitized}}/core.cljs" "src/cljs/core.cljs"]
   ["{{client-path}}/{{sanitized}}/routing.cljs" "src/cljs/routing.cljs"]
   ["{{client-path}}/{{sanitized}}/view.cljs" "src/cljs/view.cljs"]
   ])

(def project-relative-paths
  {:backend-path      "src/clj"
   :backend-test-path "test/clj"
   :client-path       "src/cljs"
   :client-test-path  "test/cljs"
   :resource-path     "resources"
   :cljc-path         "src/cljc"
   :db-path           "src/clj"
   :source-paths      ["src/clj"]
   :resource-paths    ["resources"]})

(def render (renderer "hc-admin"))

(defn hc-admin
  "FIXME: write documentation"
  [name]
  (let [data (merge
              project-relative-paths
              {:name name
               :project-ns (sanitize-ns name)
               :sanitized (name-to-path name)})]
    (main/info "Generating fresh 'lein new' hc-admin project.")
    (->files data
             ["dev-config.edn"  (render "dev-config.edn" data)]
             [".gitignore"  (render "gitignore" data)]
             ["test-config.edn"  (render "test-config.edn" data)]
             ["Procfile"  (render "Procfile" data)]
             ["project.clj"  (render "project.clj" data)]
             ["Dockerfile" (render "Dockerfile" data)]
             ["Capstanfile" (render "Capstanfile" data)]
             ["README.md" (render "README.md" data)]
             ["shadow-cljs.edn"  (render "shadow-cljs.edn" data)]
             ["package.json"  (render "package.json" data)]
             ["env/prod/resources/config.edn"  (render "env/prod/resources/config.edn" data)]
             ["env/dev/resources/config.edn"  (render "env/dev/resources/config.edn" data)]
             ["env/test/resources/config.edn"  (render "env/dev/resources/config.edn" data)]

             ;; config namespaces
             
             ["env/dev/clj/{{sanitized}}/env.clj" (render "env/dev/clj/env.clj" data)]
             ["env/dev/clj/{{sanitized}}/dev_middleware.clj"  (render "env/dev/clj/dev_middleware.clj" data)]
             
             ["env/prod/clj/{{sanitized}}/env.clj"  (render "env/prod/clj/env.clj" data)]

             ;; core namespaces
             ["env/dev/clj/user.clj" (render "env/dev/clj/user.clj" data)]
             ["{{backend-path}}/{{sanitized}}/core.clj"  (render "src/clj/core.clj" data)]
             ["{{backend-path}}/{{sanitized}}/nrepl.clj"  (render "src/clj/nrepl.clj" data)]
             ["{{backend-path}}/{{sanitized}}/config.clj"  (render "src/clj/config.clj" data)]
             ["{{backend-path}}/{{sanitized}}/handler.clj"  (render "src/clj/handler.clj" data)]
             ["{{backend-path}}/{{sanitized}}/middleware.clj"  (render "src/clj/middleware.clj" data)]
             ["{{backend-path}}/{{sanitized}}/middleware/formats.clj"  (render "src/clj/middleware/formats.clj" data)]
             ["{{backend-path}}/{{sanitized}}/middleware/exception.clj"  (render "src/clj/middleware/exception.clj" data)]
             ["{{backend-path}}/{{sanitized}}/db/core.clj"          (render "src/clj/db/core.clj" data)]
             ["{{backend-path}}/{{sanitized}}/routes/services.clj"          (render "src/clj/routes/services.clj" data)]

             ;;HTML templates
             ["{{resource-path}}/migrations/20190831145908-add-users-table.down.sql"  (render "resources/migrations/20190831145908-add-users-table.down.sql" data)]
             ["{{resource-path}}/migrations/20190831145908-add-users-table.up.sql"  (render "resources/migrations/20190831145908-add-users-table.up.sql" data)]
             ["{{resource-path}}/sql/queries.sql"  (render "resources/sql/queries.sql" data)]

             ["{{resource-path}}/public/favicon.ico"  (render "resources/public/favicon.ico" data)]
             ["{{resource-path}}/public/index.html"  (render "resources/public/index.html" data)]
             ["{{resource-path}}/public/img/warning_clojure.png"  (render "resources/public/img/warning_clojure.png" data)]

             ;; public resources, example URL: /css/screen.css
             ["{{resource-path}}/public/css/screen.css"  (render "resources/public/css/screen.css" data)]
             "{{resource-path}}/public/js"

             ;; tests
             ["{{backend-test-path}}/{{sanitized}}/test/handler.clj" (render "test/clj/handler.clj" data)]
             ["{{backend-test-path}}/{{sanitized}}/test/db/core.clj"  (render "test/clj/db/core.clj" data)]

             ;; cljs
             
             ["env/dev/cljs/{{sanitized}}/app.cljs"  (render "env/dev/cljs/app.cljs" data)]
             ["env/prod/clj/{{sanitized}}/app.cljs"  (render "env/prod/cljs/app.cljs" data)]
             ["{{client-path}}/{{sanitized}}/ajax.cljs"  (render "src/cljs/ajax.cljs" data)]
             ["{{client-path}}/{{sanitized}}/core.cljs"  (render "src/cljs/core.cljs" data)]
             ["{{client-path}}/{{sanitized}}/routing.cljs"  (render "src/cljs/routing.cljs" data)]
             ["{{client-path}}/{{sanitized}}/view.cljs"  (render "src/cljs/view.cljs" data)])))
