(ns {{project-ns}}.system.sys-user-views
  (:require
   ["antd" :as ant]
   [reagent.core :as r]
   [re-frame.core :as rf]
   [{{project-ns}}.common.utils :as utils]))

(def FormItem (.-Item ant/Form))
(def SelectOption (.-Option ant/Select))
(def Password (.-Password ant/Input))


(defn dispatch
  ([key]
   (fn [] (rf/dispatch [key])))
  ([key data]
   (fn [] (rf/dispatch [key data]))))

(def columns [
              {:title "用户名" :dataIndex "username"}
              {:title "状态" :dataIndex "enable"
               :render (fn [value]
                         (r/as-element (if (zero? value)
                                         [:> ant/Badge {:status "success" :text "启用"}]
                                         [:> ant/Badge {:status "default" :text "禁用"}])))}
              {:title "操作"
               :align "center"
               :render #(r/as-element
                         [:div
                          [:a  "编辑"]
                          [:> ant/Divider {:type "vertical"}]
                          [:a "删除"]
                          [:> ant/Divider {:type "vertical"}]
                          [:a {:on-click (dispatch :system-user/password-form-open)} "修改密码"]])}])
(defn status-select []
  [:> ant/Select {:style {:width 150} :placeholder "状态"}
   [:> SelectOption {:value 1}
    [:> ant/Badge {:status "success" :text "启用"}]]
   [:> SelectOption {:value 0}
    [:> ant/Badge {:status "default" :text "禁用"}]]])


(defn user-table-search []
  (fn [{:keys [form]}]
    (let [this (utils/get-form)]
      [:> ant/Form {:layout "inline"
                    :onSubmit (fn [e]
                                (.preventDefault e)
                                (.validateFields
                                 form
                                 (fn [err values]
                                   (rf/dispatch
                                    [:system-user/user-table-load
                                     (into {} (remove (fn [[k v]] (nil? v)) (js->clj values)))]))))}
       [:> ant/Row {:gutter 8}
        [:> ant/Col {:md 4}
         [:> FormItem
          (utils/decorate-field
           this "username"
           [:> ant/Input {:placeholder "用户名"}])]]
        [:> ant/Col {:md 4}
         [:> FormItem
          (utils/decorate-field
           this "status"
           [status-select])]]
        [:> ant/Col {:md 4}
         [:span {:className "submit-buttons"}
          [:> ant/Button {:type "primary" :htmlType "submit"} "查询"]]]]])))

(defn user-table [{:keys [data loading pagination]}]
  [:div
   [:> ant/PageHeader {:title "系统用户列表"
                       :style {:marginBottom 1}
                       :extra (r/as-element [:div
                                             [:> ant/Button
                                              {:type "primary"
                                               :on-click (dispatch :system-user/user-form-open)}
                                              "添加"]])}]
   [:> ant/Card {:bodyStyle {:paddingTop 10} :bordered false}
    [:div {:style {:marginBottom 10}}
     (utils/create-form user-table-search)]
    [:> ant/Table {:rowKey "id"
                   :columns columns
                   :dataSource data
                   :pagination {:total (:total pagination)
                                :pageSize (:size pagination)
                                :current (:page pagination)}
                   :loading (or loading false)
                   :size "middle"}]]])


(defn user-form [{:keys [visible data loading]}]
  [:> ant/Modal {:title "更新系统用户"
                 :closable false
                 :visible visible
                 :onCancel (dispatch :system-user/user-form-close)}
   (utils/create-form
    (fn [props]
      (let [this (utils/get-form)
            item-col {:labelCol {:span 5} :wrapperCol {:span 15}}]
        [:> ant/Form
         [:> FormItem (merge {:label "用户名"} item-col)
          (utils/decorate-field
           this "username"
           [:> ant/Input])]
         [:> FormItem (merge {:label "密码"} item-col)
          (utils/decorate-field
           this "password"
           [:> Password])]])))])

(defn password-form [{:keys [visible data]}]
  [:> ant/Modal {:title "修改密码"
                 :closable false
                 :visible visible
                 :onCancel (dispatch :system-user/password-form-close)}
   (utils/create-form
    (fn [props]
      (let [this (utils/get-form)
            item-col {:labelCol {:span 5} :wrapperCol {:span 15}}]
        [:> ant/Form
         [:> FormItem (merge {:label "密码"} item-col)
          (utils/decorate-field
           this "password"
           [:> Password])]])))])
