(ns <<project-ns>>.layout.layout-events
  (:require
   [kee-frame.core :as kf]
   [re-frame.core :as rf]
   [<<project-ns>>.router :refer [routes]]
   [<<project-ns>>.common.route-mapping :refer [get-routes-by-path]]))


(kf/reg-controller
 :layout/breadcrumbs-controller
 {:params (fn [route] (identity route))
  :start (fn [_ route]
           (rf/dispatch [:set-breadcrumbs route]))})

(rf/reg-event-db
 :set-breadcrumbs
 (fn [db [_ {:keys [path-params]}]]
   (assoc-in
    db
    [:layout :breadcrumbs]
    (get-routes-by-path (:path path-params) routes))))

(rf/reg-sub
 :layout/breadcrumbs
 (fn [data]
   (get-in data [:layout :breadcrumbs] [])))

(rf/reg-event-db
 :change-password
 (fn [db _]
   db))
