(ns <<project-ns>>.layout.layout-views
  (:require
   [re-frame.core :as rf]
   [reagent.core :as r]
   ["antd" :as ant]
   ["antd/es/locale/zh_CN" :default zhCN]
   [<<project-ns>>.layout.global-footer :refer [footer]]))

(def SubMenu (.-SubMenu ant/Menu))
(def MenuItem (.-Item ant/Menu))
(def Header (.-Header ant/Layout))
(def Sider (.-Sider ant/Layout))
(def Content (.-Content ant/Layout))
(def Footer (.-Footer ant/Layout))
(def BreadcrumbItem (.-Item ant/Breadcrumb))

(def collapsed (r/atom false))

(defn bread-crumbs [routes]
  [:> ant/Breadcrumb
   [:> BreadcrumbItem "首页"]
   (when routes
     (for [{:keys [title]} routes]
       ^{:key title} [:> BreadcrumbItem title]))])

(defn dropdown-menu []
  [:> ant/Menu {:className "menu"
                :onClick (fn [menu]
                           (rf/dispatch
                            [:core/nav (keyword (:key (js->clj menu :keywordize-keys true)))]))}
   [:> MenuItem {:key "change-password"}
    [:> ant/Icon {:type "lock"}]
    [:span "修改密码"]]
   [:> MenuItem {:key "login"}
    [:> ant/Icon {:type "logout"}]
    [:span "退出"]]])

(defn header-dropdown []
  [:div {:className "right"}
   [:> ant/Dropdown {:overlay (r/as-element [dropdown-menu])}
    [:span {:className "action account"}
     [:> ant/Avatar {:className "avatar" :size "small" :icon "user"}]
     [:span "管理员"]]]])

(defn basic-layout [side-menus breadcrumbs switch-route]
  [:> ant/ConfigProvider {:locale zhCN}
   [:div
    [:link {:rel "stylesheet" :href "/css/layout.css"}]
    [:> ant/Layout
     [:> Sider {:trigger nil
                :collapsible false
                :collapsed @collapsed}
      [:div {:className "logo"}]
      [side-menus]]
     [:> ant/Layout
      [:> Header {:style {:background "#fff" :padding 0}}
       [:> ant/Icon {:className "trigger"
                     :type (if-not @collapsed "menu-unfold" "menu-fold")
                     :on-click (fn [] (swap! collapsed not))}]
       [header-dropdown]]
      [:> ant/PageHeader {:style {:margin "1px 0" :padding "0 24px 8px 24px"}}
       [bread-crumbs breadcrumbs]]
      [:> Content {:style {:margin "10px 10px"
                           :minHeight 500}}
       [:div switch-route]]
      [:> Footer
       [footer "红创科技"]]]]]])
