(ns leiningen.new.generation
  (:require
   [selmer.parser :as selmer]
   [leiningen.new.templates :refer [renderer raw-resourcer ->files]]
   [clojure.pprint :refer [code-dispatch pprint with-pprint-dispatch]]
   [clojure.string :as string]
   [clojure.java.io :as io]))

(def template-name "hc-template")

(defn render-template [template options]
  (selmer/render
   (str "<% safe %>" template "<% endsafe %>")
   options
   {:tag-open \< :tag-close \> :filter-open \< :filter-close \>}))

(defn init-render []
  (renderer template-name render-template))

(defn slurp-resource [path]
  (-> (str "leiningen/new/hc_template/" path)
      io/resource
      slurp))

(selmer/add-tag!
 :include
 (fn [args context-map]
   (-> (slurp-resource (first args))
       (render-template context-map)
       (string/replace #"^\n+" "")
       (string/replace #"\n+$" ""))))

(defn render-asset [render options asset]
  (if (string? asset)
    asset
    (let [[target source] asset]
      [target (render source options)])))

(defn render-assets [assets binary-assets options]
  (let [render (init-render)
        raw (raw-resourcer template-name)]
    (apply ->files options
           (into
            (map (partial render-asset render options) assets)
            (map (fn [[target source]] [target (raw source)]) binary-assets)))))
