(ns leiningen.new.hc-template
  (:require [leiningen.new.templates :refer [multi-segment sanitize-ns renderer 
                                             name-to-path ->files project-name year sanitize]]
            [leiningen.core.main :as main]
            [selmer.parser :as selmer]
            [clojure.string :as string]
            [leiningen.new.generation :refer :all]
            [clojure.java.io :as io]))

(def timestamp (.format
                (java.text.SimpleDateFormat. "yyyyMMddHHmmss")
                (java.util.Date.)))

(def project-assets
  [["dev-config.edn"    "dev-config.edn"]
   [".gitignore"        "gitignore" ]
   ["Procfile"          "Procfile" ]
   ["project.clj"       "project.clj" ]
   ["Dockerfile"        "Dockerfile" ]
   ["Capstanfile"       "Capstanfile" ]
   ["README.md"         "README.md"]
   ["shadow-cljs.edn"   "shadow-cljs.edn" ]
   ["package.json"      "package.json" ]])

(def clj-core-aeests
  [["{{backend-path}}/{{sanitized}}/core.clj"             "src/clj/core.clj"]
   ["{{backend-path}}/{{sanitized}}/nrepl.clj"            "src/clj/nrepl.clj" ]
   ["{{backend-path}}/{{sanitized}}/config.clj"           "src/clj/config.clj"]
   ["{{backend-path}}/{{sanitized}}/handler.clj"          "src/clj/handler.clj"]
   ["{{backend-path}}/{{sanitized}}/middleware.clj"       "src/clj/middleware.clj"]
   ["{{backend-path}}/{{sanitized}}/middleware/formats.clj"     "src/clj/middleware/formats.clj"]
   ["{{backend-path}}/{{sanitized}}/middleware/exception.clj"   "src/clj/middleware/exception.clj"]
   ["{{backend-path}}/{{sanitized}}/db/core.clj"             "src/clj/db/core.clj"]
   ["{{backend-path}}/{{sanitized}}/routes/services.clj"     "src/clj/routes/services.clj"]
   ["{{backend-path}}/{{sanitized}}/routes/demo.clj"         "src/clj/routes/demo.clj"]
   ;;test
   ["{{backend-test-path}}/{{sanitized}}/test/handler.clj"   "test/clj/handler.clj"]
   ["{{backend-test-path}}/{{sanitized}}/test/db/core.clj"   "test/clj/db/core.clj"]
   ;; hc clj
   ["{{backend-path}}/{{sanitized}}/db/redis.clj"            "src/clj/db/redis.clj"]
   ["{{backend-path}}/{{sanitized}}/common/result.clj"       "src/clj/common/result.clj"]
   ["{{backend-path}}/{{sanitized}}/common/utils.clj"        "src/clj/common/utils.clj"]
   ["{{backend-path}}/{{sanitized}}/routes/service/file.clj"        "src/clj/routes/service/file.clj"]])

(def environment-assets 
  [["env/dev/clj/user.clj"                "env/dev/clj/user.clj"]
   ["env/dev/resources/config.edn"        "env/dev/resources/config.edn"]
   ["env/dev/resources/logback.xml"       "env/dev/resources/logback.xml"]
   ["env/dev/clj/{{sanitized}}/env.clj"   "env/dev/clj/env.clj"]
   ["env/test/resources/config.edn"    "env/test/resources/config.edn"]
   ["env/test/resources/logback.xml"   "env/test/resources/logback.xml"]
   ["env/prod/resources/config.edn"    "env/prod/resources/config.edn"]
   ["env/prod/resources/logback.xml"   "env/prod/resources/logback.xml"]
   
   ["env/dev/clj/{{sanitized}}/env.clj"              "env/dev/clj/env.clj"]
   ["env/dev/clj/{{sanitized}}/dev_middleware.clj"   "env/dev/clj/dev_middleware.clj"]
   ["env/prod/clj/{{sanitized}}/env.clj"   "env/prod/clj/env.clj"]])

(def db-assets
  [[(str "{{resource-path}}/migrations/" timestamp "-add-users-table.down.sql")   "resources/migrations/20190831145908-add-users-table.down.sql"]
   [(str "{{resource-path}}/migrations/" timestamp "-add-users-table.up.sql")   "resources/migrations/20190831145908-add-users-table.up.sql"]
   ["{{resource-path}}/sql/queries.sql"   "resources/sql/queries.sql"]])

(def cljs-core-assets
  [["env/dev/cljs/{{sanitized}}/app.cljs"             "env/dev/cljs/app.cljs"]
   ["env/prod/clj/{{sanitized}}/app.cljs"             "env/prod/cljs/app.cljs"]
   ["{{client-path}}/{{sanitized}}/config.cljs"       "src/cljs/config.cljs"]
   ["{{client-path}}/{{sanitized}}/core.cljs"         "src/cljs/core.cljs"]
   ["{{client-path}}/{{sanitized}}/default_db.cljs"   "src/cljs/default_db.cljs"]
   ["{{client-path}}/{{sanitized}}/index.cljs"        "src/cljs/index.cljs"]
   ["{{client-path}}/{{sanitized}}/router.cljs"       "src/cljs/router.cljs"]
   ["{{client-path}}/{{sanitized}}/url.cljs"          "src/cljs/url.cljs"]
   ;; css
   ["{{resource-path}}/public/css/layout.css"    "resources/public/css/layout.css"]
   ["{{resource-path}}/public/css/login.css"     "resources/public/css/login.css"]
   ["{{resource-path}}/public/css/product.css"   "resources/public/css/product.css"]
   ["{{resource-path}}/public/css/footer_toolbar.css"   "resources/public/css/footer_toolbar.css"]
   ["{{resource-path}}/public/css/custom.css"   "resources/public/css/custom.css"]
   ;; login
   ["{{client-path}}/{{sanitized}}/login/login_views.cljs"      "src/cljs/login/login_views.cljs"]
   ["{{client-path}}/{{sanitized}}/login/login_events.cljs"     "src/cljs/login/login_events.cljs"]
   ;;layout-5
   ["{{client-path}}/{{sanitized}}/layout/layout_views.cljs"    "src/cljs/layout/layout_views.cljs"]
   ["{{client-path}}/{{sanitized}}/layout/layout_events.cljs"   "src/cljs/layout/layout_events.cljs"]
   ["{{client-path}}/{{sanitized}}/layout/layout_main.cljs"     "src/cljs/layout/layout_main.cljs"]
   ["{{client-path}}/{{sanitized}}/layout/global_footer.cljs"   "src/cljs/layout/global_footer.cljs"]
   ["{{client-path}}/{{sanitized}}/layout/side_menu.cljs"       "src/cljs/layout/side_menu.cljs"]
   ;;common-4
   ["{{client-path}}/{{sanitized}}/common/utils.cljs"           "src/cljs/common/utils.cljs"]
   ["{{client-path}}/{{sanitized}}/common/route_mapping.cljs"   "src/cljs/common/route_mapping.cljs"]
   ["{{client-path}}/{{sanitized}}/common/storage.cljs"         "src/cljs/common/storage.cljs"]
   ["{{client-path}}/{{sanitized}}/common/request.cljs"           "src/cljs/common/request.cljs"]

   ;;components-3
   ["{{client-path}}/{{sanitized}}/components/common_page.cljs"         "src/cljs/components/common_page.cljs"]
   ["{{client-path}}/{{sanitized}}/components/upload.cljs"              "src/cljs/components/upload.cljs"]
   ["{{client-path}}/{{sanitized}}/components/search_product.cljs"      "src/cljs/components/search_product.cljs"]
   
   ;;product demo
   ["{{client-path}}/{{sanitized}}/product/events/custom_craftwork_events.cljs"     "src/cljs/product/events/custom_craftwork_events.cljs"]
   ["{{client-path}}/{{sanitized}}/product/events/custom_embroidery_events.cljs"    "src/cljs/product/events/custom_embroidery_events.cljs"]
   ["{{client-path}}/{{sanitized}}/product/events/custom_fabric_events.cljs"        "src/cljs/product/events/custom_fabric_events.cljs"]
   
   ["{{client-path}}/{{sanitized}}/product/product_events.cljs"         "src/cljs/product/product_events.cljs"]
   ["{{client-path}}/{{sanitized}}/product/product_data_convert.cljs"   "src/cljs/product/product_data_convert.cljs"]
   ["{{client-path}}/{{sanitized}}/product/product_form_component.cljs" "src/cljs/product/product_form_component.cljs"]
   ["{{client-path}}/{{sanitized}}/product/product_info_views.cljs"     "src/cljs/product/product_info_views.cljs"]
   ["{{client-path}}/{{sanitized}}/product/product_init_db.cljs"        "src/cljs/product/product_init_db.cljs"]
   ["{{client-path}}/{{sanitized}}/product/product_list_views.cljs"     "src/cljs/product/product_list_views.cljs"]
   ["{{client-path}}/{{sanitized}}/product/product_sub.cljs"            "src/cljs/product/product_sub.cljs"]

   
   ])

(def system-assets
  [;;system-user demo
   ["{{client-path}}/{{sanitized}}/system/sys_user_views.cljs"    "src/cljs/system/sys_user_views.cljs"]
   ["{{client-path}}/{{sanitized}}/system/sys_user_events.cljs"   "src/cljs/system/sys_user_events.cljs"]
   ["{{client-path}}/{{sanitized}}/system/sys_user_sub.cljs"      "src/cljs/system/sys_user_sub.cljs"]
   ["{{client-path}}/{{sanitized}}/system/sys_user_main.cljs"     "src/cljs/system/sys_user_main.cljs"]])

(def binary-assets
  [["{{resource-path}}/public/favicon.ico"              "resources/public/favicon.ico"]
   ["{{resource-path}}/public/index.html"               "resources/public/index.html"]
   ["{{resource-path}}/public/img/warning_clojure.png"  "resources/public/img/warning_clojure.png"]
   ["{{resource-path}}/public/img/img_index.png"        "resources/public/img/img_index.png"]])

(def core-assets
  (vec (concat project-assets
               clj-core-aeests
               environment-assets
               db-assets
               cljs-core-assets
               system-assets)))

(def project-relative-paths
  {:backend-path      "src/clj"
   :backend-test-path "test/clj"
   :client-path       "src/cljs"
   :client-test-path  "test/cljs"
   :resource-path     "resources"
   :cljc-path         "src/cljc"
   :db-path           "src/clj"
   :source-paths      ["src/clj"]
   :resource-paths    ["resources"]
   :now               (java.util.Date.)})

(def render (renderer "hc-template" render-template))

(defn generate-project
  "Create a new Luminus project"
  [options]
  (main/info "Generating a hc-template project. Please read README.md firstly !")
  (render-assets core-assets binary-assets  options))

(defn hc-template
  "init function"
  [name]
  (let [options (merge
                 project-relative-paths
                 {:name             (project-name name)
                  :selmer-renderer  render-template
                  :min-lein-version "2.0.0"
                  :project-ns       (sanitize-ns name)
                  :sanitized        (name-to-path name)
                  :year             (year)
                  })]
    (generate-project options)))

