(ns <<project-ns>>.components.common-page
  (:require
   ["antd" :as ant]
   [reagent.core :as r]))

(defn main-page []
  (let [this (r/current-component)
        props (r/props this)]
    [:div
     [:> ant/PageHeader {:onBack (:on-back props)
                         :title (:title props)
                         :extra (:extra props)
                         :style {:margin-bottom 1}}]
     (into [:> ant/Card {:bordered false}] (r/children this))]))

;;分页表格
(defn pagination-table [{:keys [pagination on-change on-size-change] :as props}]
  [:> ant/Table
   (merge
    {:size "middle"
     :pagination
     (merge
      {:size "default"
       :total 0
       :pageSize 0
       :current 0
       :showQuickJumper true
       :showSizeChanger true
       :showTotal (fn [total]
                    (r/as-element [:span
                                   {:style {:margin-right 20}}
                                   "共计"
                                   [:span {:style {:font-size 16
                                                   :font-weight "bold"}} total]
                                   "条"]))}
      pagination)
     :onShowSizeChange
     (fn [current size]
       (when on-size-change
         (on-size-change current size)))
     :onChange
     (fn [pagination]
       (when on-change
         (on-change (js->clj pagination :keywordize-keys true))))}
    (dissoc props :pagination :on-change))])

;;图片预览
(defn image-preview []
  (def visible? (r/atom false))
  (def preview-url (r/atom ""))
  (fn []
    (let [props (r/props (r/current-component))]
      [:div
       [:> ant/Tooltip {:title "点击预览"}
        [:a {:on-click (fn []
                         (reset! visible? true)
                         (reset! preview-url (:src props)))}
         [:img props]]]
       [:> ant/Modal {:visible @visible?
                      :style {:top 20}
                      :footer nil
                      :onCancel #(reset! visible? false)}
        [:img
         {:style {:width "100%"}
          :src @preview-url}]]])))

(defn footer-toolbar []
  (let [this (r/current-component)]
    [:div
     [:link {:rel "stylesheet" :href "/css/footer_toolbar.css"}]
     [:div.toolbar
      (into [:div.right] (r/children this))]]))
