(ns <<project-ns>>.login.login-events
  (:require
   [kee-frame.core :as kf]
   [re-frame.core :as rf]
   [<<project-ns>>.url :refer [auth-url base-url]]
   [<<project-ns>>.common.storage :as storage]))

(kf/reg-controller
 :login-interceptor
 {:params (fn [route]
            (when (nil? (storage/get-token-storage))
              route))
  :start  (fn [] [:core/nav :login])})

(kf/reg-event-fx
 :login
 (fn [{:keys [db]} [params]]
   {:db (assoc-in db [:login :loading] true)
    :dispatch [:request/post {:url (:token auth-url)
                              :params params
                              :with-code? true
                              :callback-event :login/handler}]}) )

(kf/reg-chain
 :login/handler
 (fn [{:keys [db]} [{:keys [code msg data]}]]
   (when (zero? code)
     (do
       (storage/set-token-storage data)
       (rf/dispatch [:base/fetch-company])
       (rf/dispatch [:core/nav :main {:path ""} ])))
   {:db (update db :login #(assoc % :result true :loading false))}))

(kf/reg-event-fx
 :logout
 (fn [{:keys [db]}]
   (storage/remove-token-storage)
   {:db db
    :dispatch [:core/nav :login]}))

(rf/reg-sub
 :login/result
 (fn [db]
   (get-in db [:login :result])))


(rf/reg-sub
 :login/loading
 (fn [db]
   (get-in db [:login :loading] false)))

(kf/reg-controller
 :login-interceptor
 {:params identity
  :start  [:base/fetch-company]})

(kf/reg-event-fx
 :base/fetch-company
 (fn [{:keys [db]} _]
   (when (nil? (get-in db [:base :company :data]))
     {:db (assoc-in db [:base :company :loading] true)
      :dispatch [:request/get {:url (:company base-url)
                               :callback-event :base/fetch-company-success}]})))

(kf/reg-event-fx
 :base/fetch-company-success
 (fn [{:keys [db]} [data]]
   {:db (update-in db [:base :company] #(assoc % :loading false :data data))}))

(rf/reg-sub
 :base/company-loading
 (fn [db]
   (get-in db [:base :company :loading] false)))

(rf/reg-sub
 :base/company-logo
 (fn [db]
   (get-in db [:base :company :data :company_logo] nil)))

(rf/reg-sub
 :base/company-name
 (fn [db]
   (get-in db [:base :company :data :company_name] nil)))

(rf/reg-sub
 :base/company-index
 (fn [db]
   (get-in db [:base :company :data :company_index_url] nil)))
