(ns <<project-ns>>.product.events.custom-craftwork-events
  (:require
   ["uuid" :as uid]
   [re-frame.core :as rf]
   [kee-frame.core :as kf]
   [<<project-ns>>.config :refer [domain]]))

(defn positions-url [category-id]
  (str domain "/admin/product/craftwork/" category-id))

(defn crafts-url [parent-id]
  (str domain "/admin/product/craftworks/" parent-id))

(kf/reg-event-fx
 :product/fetch-positions
 (fn [{:keys [db]} [{:keys [category_id] :as query}]]
   {:db (assoc-in db [:product :positions :loading] true)
    :dispatch [:request/get {:url (positions-url category_id)
                             :callback-event :product/set-positions}]}))

(kf/reg-event-fx
 :product/fetch-style-crafts
 (fn [_ [{:keys [id] :as query}]]
   {:dispatch [:request/get {:url  (crafts-url id)
                             :params query
                             :callback-event :product/add-style-position-crafts}]}))

(kf/reg-event-fx
 :product/fetch-deep-crafts
 (fn [_ [{:keys [id] :as query}]]
   {:dispatch [:request/get {:url (crafts-url id)
                             :params query
                             :callback-event :product/add-deep-position-crafts}]}))

(defn position->custom-item [position]
  {:id (:craftwork_id position)
   :value (:craft_name position)})

(kf/reg-event-db
 :product/set-positions
 (fn [db [positions]]
   (update-in db [:product :positions]
              #(assoc % :loading false :data (map position->custom-item positions)))))

(defn craft->custom-item [craft]
  {:id (:craftwork_id craft)
   :value (:craft_name craft)
   :code (:craft_code craft)
   :price (:craft_price craft)
   :img (:craft_image craft)})

(defn update-positions [data position positions]
  (if (some #(= (:id position) (:id %)) positions)
    (map (fn [pos]
           (if (= (:id position) (:id pos))
             (assoc pos :crafts (map craft->custom-item data))
             (identity pos))) positions)
    (concat positions [(merge position {:crafts (map craft->custom-item data)})])))

(kf/reg-event-db
 :product/add-style-position-crafts
 (fn [db [data position]]
   (update-in db [:product :detail :style-positions]
              #(update-positions data position %))))

(kf/reg-event-db
 :product/add-deep-position-crafts
 (fn [db [data position]]
   (update-in db [:product :detail :deep-positions]
              #(update-positions data position %))))

(kf/reg-event-db
 :product/set-style-craft-custom
 (fn [db [custom?]]
   (assoc-in db [:product :detail :style-craftwork-custom?] custom?)))

(kf/reg-event-db
 :product/set-deep-craft-custom
 (fn [db [custom?]]
   (assoc-in db [:product :detail :deep-craftwork-custom?] custom?)))

(kf/reg-event-fx
 :product/selected-style-position
 (fn [_ [position]]
   {:dispatch [:product/fetch-style-crafts (merge position {:category_id "1012"})]}))

(kf/reg-event-fx
 :product/selected-deep-position
 (fn [_ [position]]
   {:dispatch [:product/fetch-deep-crafts (merge position {:category_id "1012"})]}))

(kf/reg-event-db
 :product/deselect-style-position
 (fn [db [position]]
   (update-in
    db
    [:product :detail :style-positions]
    #(remove (fn [item] (= (:id item) (:id position))) %))))

(kf/reg-event-db
 :product/deselect-deep-position
 (fn [db [position]]
   (update-in
    db
    [:product :detail :deep-positions]
    #(remove (fn [item] (= (:id item) (:id position))) %))))

(kf/reg-event-db
 :product/set-style-position-selected-crafts
 (fn [db [position selected-crafts]]
   (update-in
    db
    [:product :detail :style-positions]
    #(map
      (fn [item]
        (if (= (:id item) (:id position))
          (assoc item :selected-crafts selected-crafts)
          (identity item))) %))))

(kf/reg-event-db
 :product/set-deep-position-selected-crafts
 (fn [db [position selected-crafts]]
   (update-in
    db
    [:product :detail :deep-positions]
    #(map
      (fn [item]
        (if (= (:id item) (:id position))
          (assoc item :selected-crafts selected-crafts)
          (identity item))) %))))

(defn update-selected-crafts [craft selected-crafts]
  (map
   (fn [item]
     (if (= (:id item) (:id craft))
       (identity craft)
       (if (:default? craft)
         (assoc item :default? false)
         (identity item))))
   selected-crafts))

(kf/reg-event-db
 :product/update-style-position-selected-crafts
 (fn [db [position craft]]
   (update-in
    db
    [:product :detail :style-positions]
    #(map
      (fn [item]
        (if (= (:id item) (:id position))
          (assoc
           item
           :selected-crafts
           (update-selected-crafts craft (:selected-crafts item)))
          (identity item))) %))))

(kf/reg-event-db
 :product/update-deep-position-selected-crafts
 (fn [db [position craft]]
   (update-in
    db
    [:product :detail :deep-positions]
    #(map
      (fn [item]
        (if (= (:id item) (:id position))
          (assoc
           item
           :selected-crafts
           (update-selected-crafts craft (:selected-crafts item)))
          (identity item))) %))))

(rf/reg-sub
 :product/style-craft-custom?
 (fn [db]
   (get-in db [:product :detail :style-craftwork-custom?] true)))

(rf/reg-sub
 :product/deep-craft-custom?
 (fn [db]
   (get-in db [:product :detail :deep-craftwork-custom?] true)))

(rf/reg-sub
 :product/detail-style-positions
 (fn [db]
   (get-in db [:product :detail :style-positions] [])))

(rf/reg-sub
 :product/detail-deep-positions
 (fn [db]
   (get-in db [:product :detail :deep-positions] [])))

(rf/reg-sub
 :product/style-positions-values
 :<- [:product/detail-style-positions]
 (fn [positions]
   (map :value positions)))

(rf/reg-sub
 :product/deep-positions-values
 :<- [:product/detail-deep-positions]
 (fn [positions]
   (map :value positions)))

(rf/reg-sub
 :product/positions
 (fn [db]
   (get-in db [:product :positions :data] [])))

(rf/reg-sub
 :product/positions-loading
 (fn [db]
   (get-in db [:product :positions :loading] false)))
