(ns <<project-ns>>.product.events.custom-embroidery-events
  (:require
   ["uuid" :as uid]
   [re-frame.core :as rf]
   [kee-frame.core :as kf]
   [<<project-ns>>.config :refer [domain]]))

(defn embroideries-url [category-id]
  (str domain "/admin/embroidery/positions/" category-id))

(kf/reg-chain
 :product/fetch-embroideries
 (fn [{:keys [db]} [{:keys [category_id] :as query}]]
   {:db (assoc-in db [:product :embroideries :loading] true)
    :dispatch [:request/get {:url (embroideries-url category_id)
                             :callback-event :product/set-embroideries}]}))

(defn embroidery->custom-item [embroidery]
  {:id (:position_id embroidery)
   :value (:position_name embroidery)
   :code (::position_code embroidery)
   :img (:position_image embroidery)})

;;设置刺绣下拉数据
(kf/reg-event-db
 :product/set-embroideries
 (fn [db [embroideries]]
   (update-in db [:product :embroideries]
              #(assoc % :loading false :data (map embroidery->custom-item embroideries)))))

(rf/reg-sub
 :product/embroideries-data
 (fn [db]
   (get-in db [:product :embroideries :data] [])))

(rf/reg-sub
 :product/embroideries-loading
 (fn [db]
   (get-in db [:product :embroideries :loading] false)))

;;刺绣是否定制
(kf/reg-event-db
 :product/set-detail-embroidery-custom
 (fn [db [custom?]]
   (assoc-in db [:product :detail :embroidery-custom?] custom?)))

(rf/reg-sub
 :product/detail-embroidery-custom?
 (fn [db]
   (get-in db [:product :detail :embroidery-custom?] true)))

;;选中的刺绣
(kf/reg-event-db
 :product/set-detail-embroideries
 (fn [db [embroideries]]
   (assoc-in db [:product :detail :embroideries] embroideries)))

(rf/reg-sub
 :product/detail-embroideries
 (fn [db]
   (get-in db [:product :detail :embroideries] [])))

(rf/reg-sub
 :product/embroideries-values
 :<- [:product/detail-embroideries]
 (fn [embroideries]
   (map :value embroideries)))
