(ns <<project-ns>>.product.events.custom-fabric-events
  (:require
   ["uuid" :as uid]
   [re-frame.core :as rf]
   [kee-frame.core :as kf]
   [<<project-ns>>.config :refer [domain]]))

(defn fabrics-url [category-id]
  (str domain "/admin/product/fabrics/" category-id))

(kf/reg-chain
 :product/fetch-fabrics
 (fn [{:keys [db]} [{:keys [category_id] :as query}]]
   {:db (assoc-in db [:product :fabric :loading] true)
    :dispatch [:request/get {:url  (fabrics-url category_id)
                             :callback-event  :product/set-fabrics}]}))

(defn fabric->custom-item [fabric]
  {:id (:fabric_id fabric)
   :value (:fabric_code fabric)
   :name (:fabric_name fabric)
   :price (:fabric_price fabric)
   :img (:fabric_url fabric)})

(kf/reg-event-db
 :product/set-fabrics
 (fn [db [fabrics]]
   (update-in db [:product :fabric]
              #(assoc % :loading false :data (map fabric->custom-item fabrics)))))

(kf/reg-event-db
 :product/set-detail-fabrics
 (fn [db [fabrics]]
   (assoc-in db [:product :detail :fabrics] fabrics)))

(kf/reg-event-db
 :product/update-detail-fabric
 (fn [db [fabric]]
   (update-in db [:product :detail :fabrics]
              #(map (fn [item]
                      (if (= (:id item) (:id fabric))
                        (identity fabric)
                        (if (:default? fabric)
                          (assoc item :default? false)
                          (identity item)))) %))))

(kf/reg-event-db
 :product/remove-detail-fabric
 (fn [db [fabric]]
   (update-in db [:product :detail :fabrics]
              #(remove (fn [item] (= (:id item) (:id fabric))) %))))

(kf/reg-event-db
 :product/set-detail-fabric-custom
 (fn [db [custom?]]
   (assoc-in db [:product :detail :fabric-custom?] custom?)))

(rf/reg-sub
 :product/detail-fabrics
 (fn [db]
   (get-in db [:product :detail :fabrics] [])))

(rf/reg-sub
 :product/detail-fabric-custom?
 (fn [db]
   (get-in db [:product :detail :fabric-custom?] true)))

(rf/reg-sub
 :product/fabric-values
 :<- [:product/detail-fabrics]
 (fn [fabrics]
   (map :value fabrics)))

(rf/reg-sub
 :product/fabric-data
 (fn [db]
   (get-in db [:product :fabric :data] [])))

(rf/reg-sub
 :product/fabric-loading
 (fn [db]
   (get-in db [:product :fabric :loading] false)))
