(ns <<project-ns>>.product.product-info-views
  (:require
   ["antd" :as ant]
   [reagent.core :as r]
   [re-frame.core :as rf]
   [<<project-ns>>.common.utils :as utils]
   [<<project-ns>>.product.product-events]
   [<<project-ns>>.product.product-form-component :as component]
   [<<project-ns>>.components.upload :refer [file-upload]]
   [<<project-ns>>.components.common-page :refer [main-page footer-toolbar]]))

(def Option (.-Option ant/Select))
(def FormItem (.-Item ant/Form))
(def TextArea (.-TextArea ant/Input))
(def RadioGroup (.-Group ant/Radio))
(def TreeNode (.-TreeNode ant/TreeSelect))
(def Step (.-Step ant/Steps))

(declare product-info-form)
(declare product-custom-form)

(def step-froms [#'product-info-form #'product-custom-form])

(def product-detail (rf/subscribe [:product/detail]))

(defn product-info-page []
  (fn []
    [main-page {:title
                (if (:product-id @product-detail) "更新商品信息" "添加商品信息")
                :on-back #(rf/dispatch [:core/nav :main {:path "/product/list"}])}
     [:div
      [:> ant/Row
       [:> ant/Col {:span 20 :offset 3}
        [:> ant/Spin {:spinning (:loading @product-detail)}
         [:> ant/Row {:style {:margin-bottom 30}}
          [:> ant/Col {:span 12 :offset 3}
           [:> ant/Steps {:current (:current-step @product-detail)
                          :size "small"}
            [:> Step {:title "商品基本信息"}]
            [:> Step {:title "商品定制信息"}]]]]
         [(step-froms (:current-step @product-detail))]]]]]]))

(declare one-col-item)
(declare two-col-item)
(declare three-col-item)
(declare step-btn)

(defn product-info-form []
  (utils/create-form
   (fn [{:keys [this]}]
     (let [form (utils/get-form)
           field-decorator (:getFieldDecorator form)]

       [:> ant/Form

        [two-col-item
         "商品名称"
         (utils/decorate-field
          form "product-name"
          {:rules [{:required true
                    :message "请输入商品名称"}]
           :initialValue (:product-name @product-detail)}
          [:> ant/Input
           {:style {:width 200}
            :placeholder "请选输入商品名称"}])
         "商品编码"
         (utils/decorate-field
          form "product-no"
          {:rules [{:required true
                    :message "请输入商品编码"}]
           :initialValue (:product-no @product-detail)}
          [:> ant/Input
           {:style {:width 200}
            :placeholder "请选输入商品编码"}])]

        [two-col-item
         "商品价格:"
         (utils/decorate-field
          form "sale-price"
          {:rules [{:required true
                    :message "请输入商品编码"}]
           :initialValue (:sale-price @product-detail)}
          [:> ant/InputNumber {:placeholder "请输入商品价格" :min 0 :style {:width 200}}])
         "会员价格:"
         (utils/decorate-field
          form "vip-price"
          {:rules [{:required true
                    :message "请输入商品编码"}]
           :initialValue (:vip-price @product-detail)}
          [:> ant/InputNumber {:placeholder "请输入会员价格" :min 0 :style {:width 200}}])]

        [two-col-item
         "商品品类:"
         (utils/decorate-field
          form "category-ids"
          {:rules [{:required true
                    :message "请选择商品品类"}]
           :initialValue (:category-ids @product-detail)}
          [:> ant/Cascader
           {:style {:width 200}
            :placeholder "请选择品类"
            :options @(rf/subscribe [:product/categories])
            :onChange (fn [value options]
                        (let [category-id (second (js->clj value :keywordize-keys true))]
                          (rf/dispatch [:product/fetch-fabrics {:category_id category-id}])
                          (rf/dispatch [:product/fetch-positions {:category_id category-id}])
                          (rf/dispatch [:product/fetch-embroideries {:category_id category-id}])))}])
         "定制类型:"
         (utils/decorate-field
          form  "custom-type"
          {:rules [{:required true
                    :message "请输入商品编码"}]
           :initialValue (or (:custom-type @product-detail) "1")}
          [:> RadioGroup
           {:onChange (fn [e]
                        (let [value (-> (js->clj e :keywordize-keys true) :target :value)]
                          (rf/dispatch [:product/set-product-custom? (= value "2")])))}
           [:> ant/Radio {:value "1"} "不可定制"]
           [:> ant/Radio {:value "2"} "可定制"]])]

        [one-col-item
         "商品套装:"
         (utils/decorate-field
          form  "suit-type"
          {:rules [{:required true
                    :message "请输入商品编码"}]
           :initialValue (or (:suit-type @product-detail) "0")}
          [:> RadioGroup {:onChange (fn [e]
                                      (let [value (-> (js->clj e :keywordize-keys true) :target :value)]
                                        (rf/dispatch [:product/show-suit-products (= value "1")])))}
           [:> ant/Radio {:value "0"} "单品"]
           [:> ant/Radio {:value "1"} "套装"]])]

        (when (:suit-products-visible @product-detail)
          [:> ant/Row {:style {:margin-bottom 20}}
           [:> ant/Col {:span 16 :offset 1}
            [component/suit-products-table]]])

        [one-col-item
         "规格参数"
         (utils/decorate-field
          form "params" {:initialValue (or (:params @product-detail) [])}
          (r/create-element (r/reactify-component component/parameter-input)))]

        [one-col-item
         "服务参数"
         (utils/decorate-field
          form "services" {:initialValue (or (:services @product-detail) [])}
          (r/create-element (r/reactify-component component/parameter-input)))]

        [one-col-item
         "商品简介"
         (utils/decorate-field
          form "product-intro"
          {:rules [{:required true
                    :message "请输入商品简介"}]
           :initialValue (:product-intro @product-detail)}
          [:> TextArea {:placeholder "请输入商品简介"
                        :style {:width 420
                                :height 100}}])]

        [three-col-item
         "上下架"
         (utils/decorate-field
          form "online?"
          {:valuePropName "checked"
           :initialValue (:online? @product-detail)}
          [:> ant/Switch
           {:checkedChildren "上架"
            :unCheckedChildren "下架"}])
         "是否推荐"
         (utils/decorate-field
          form "recommend?"
          {:valuePropName "checked"
           :initialValue (:recommend? @product-detail)}
          [:> ant/Switch
           {:checkedChildren "推荐"
            :unCheckedChildren "不推荐"}])]

        [one-col-item
         "封面图片:"
         [file-upload
          {:files @(rf/subscribe [:product/detail-cover-imgs])
           :data {:file_prefix "product/cover"}
           :on-change (fn [{:keys [file]}]
                        (rf/dispatch [:product/set-cover-imgs file]))}]]

        [one-col-item
         "轮播图片:"
         [file-upload
          {:multi? true
           :files @(rf/subscribe [:product/detail-banner-imgs])
           :data {:file_prefix "product/banner"}
           :on-change (fn [{:keys [file fileList]}]
                        (rf/dispatch [:product/set-banner-imgs file]))}]]

        [one-col-item
         "详细图片:"
         [file-upload
          {:multi? true
           :files @(rf/subscribe [:product/detail-detail-imgs])
           :data {:file_prefix "product/detail"}
           :on-change (fn [{:keys [file]}]
                        (rf/dispatch [:product/set-detail-imgs file]))}]]

        [step-btn
         {:form form
          :current-ste (:current-step @product-detail)
          :product-custom (:product-custom @product-detail)
          :submit-loading (:submit-loading @product-detail)}]]))))

(defn product-custom-form []
  (fn []
    (utils/create-form
     (fn [props]
       (let [this (utils/get-form)]
         [:> ant/Form
          [:div {:style {:margin-left -50}}
           [:link {:rel "stylesheet" :href "/css/custom.css"}]

           ;;面料定制
           (let [custom? (rf/subscribe [:product/detail-fabric-custom?])
                 select-data (rf/subscribe [:product/fabric-data])
                 select-loading (rf/subscribe [:product/fabric-loading])
                 selected-values (rf/subscribe [:product/fabric-values])
                 item-data (rf/subscribe [:product/detail-fabrics])]
             [:div
              [:> ant/Divider {:orientation "left"} "面料定制"]
              [component/custom-radio
               {:custom? @custom?
                :on-radio-change #(rf/dispatch [:product/set-detail-fabric-custom %])}]
              (when @custom?
                [component/custom-select-item
                 {:title "面料"
                  :placeholder "请选择面料"
                  :allow-clear true
                  :select-data @select-data
                  :select-values @selected-values
                  :select-loading @select-loading
                  :on-select-change #(rf/dispatch [:product/set-detail-fabrics %])
                  :item-data @item-data
                  :show-default? true
                  :on-item-change #(rf/dispatch [:product/update-detail-fabric %])}])])

           ;;款式定制
           (let [custom? @(rf/subscribe [:product/style-craft-custom?])
                 positions @(rf/subscribe [:product/detail-style-positions])
                 select-data @(rf/subscribe [:product/positions])
                 selected-values @(rf/subscribe [:product/style-positions-values])
                 select-loading @(rf/subscribe [:product/positions-loading])]
             [:div
              [:> ant/Divider {:orientation "left"} "款式定制"]
              [component/custom-radio
               {:custom? custom?
                :on-radio-change #(rf/dispatch [:product/set-style-craft-custom %])}]
              (when custom?
                [:div
                 [component/custom-select
                  {:title "开放部位"
                   :placeholder "请选择部位"
                   :select-data select-data
                   :select-values selected-values
                   :select-loading select-loading
                   :on-select #(rf/dispatch [:product/selected-style-position %])
                   :on-deselect #(rf/dispatch [:product/deselect-style-position %])}]
                 (for [position positions]
                   [:> ant/Row {:style {:margin-bottom 10}}
                    [:> ant/Col {:span 24}
                     [:> ant/Card {:bodyStyle {:background "#fafafa" :padding "15px 0"}}
                      [component/custom-select-item
                       {:title (:value position)
                        :placeholder "请选择工艺"
                        :select-data (:crafts position)
                        :select-values (map :value (:selected-crafts position))
                        :select-loading false
                        :on-select-change #(rf/dispatch [:product/set-style-position-selected-crafts position %])
                        :item-data (:selected-crafts position)
                        :show-default? true
                        :price-disable? true
                        :on-item-change #(rf/dispatch [:product/update-style-position-selected-crafts position %])}]]]])])])

           ;;深度定制
           (let [custom? @(rf/subscribe [:product/deep-craft-custom?])
                 positions @(rf/subscribe [:product/detail-deep-positions])
                 select-data @(rf/subscribe [:product/positions])
                 selected-values @(rf/subscribe [:product/deep-positions-values])
                 select-loading @(rf/subscribe [:product/positions-loading])]
             [:div
              [:> ant/Divider {:orientation "left"} "深度定制"]
              [component/custom-radio
               {:custom? custom?
                :on-radio-change #(rf/dispatch [:product/set-deep-craft-custom %])}]
              (when custom?
                [:div
                 [component/custom-select
                  {:title "开放部位"
                   :placeholder "请选择部位"
                   :select-data select-data
                   :select-values selected-values
                   :select-loading select-loading
                   :on-select #(rf/dispatch [:product/selected-deep-position %])
                   :on-deselect #(rf/dispatch [:product/deselect-deep-position %])}]
                 (for [position positions]
                   [:> ant/Row {:style {:margin-bottom 10}}
                    [:> ant/Col {:span 24}
                     [:> ant/Card {:bodyStyle {:background "#fafafa" :padding "15px 0"}}
                      [component/custom-select-item
                       {:title (:value position)
                        :placeholder "请选择工艺"
                        :select-data (:crafts position)
                        :select-values (map :value (:selected-crafts position))
                        :select-loading false
                        :on-select-change #(rf/dispatch [:product/set-deep-position-selected-crafts position %])
                        :item-data (:selected-crafts position)
                        :show-default? true
                        :price-disable? true
                        :on-item-change #(rf/dispatch [:product/update-deep-position-selected-crafts position %])}]]]])])])
           ;;刺绣定制
           (let [custom? @(rf/subscribe [:product/detail-embroidery-custom?])
                 select-data @(rf/subscribe [:product/embroideries-data])
                 select-loading @(rf/subscribe [:product/embroideries-loading])
                 selected-values @(rf/subscribe [:product/embroideries-values])
                 item-data @(rf/subscribe [:product/detail-embroideries])]
             [:div
              [:> ant/Divider {:orientation "left"} "刺绣定制"]
              [component/custom-radio
               {:custom? custom?
                :on-radio-change #(rf/dispatch [:product/set-detail-embroidery-custom %])}]
              (when custom?
                [component/custom-select-item
                 {:title "刺绣"
                  :placeholder "请选择面料"
                  :select-data select-data
                  :select-values selected-values
                  :select-loading select-loading
                  :on-select-change #(rf/dispatch [:product/set-detail-embroideries %])
                  :item-data item-data
                  :show-default? false
                  :show-price? false}])])

           [step-btn
            {:form this
             :current-step (:current-step @product-detail)
             :submit-loading (:submit-loading @product-detail)}]]])))))
(defn step-btn []
  (fn []
    (let [{:keys [form current-step product-custom submit-loading]} (r/props (r/current-component))]
      [footer-toolbar
       (when (pos? current-step)
         [:> ant/Button {:style
                         {:margin-right 15}
                         :on-click
                         (fn []
                           (rf/dispatch [:product/set-current-step (dec current-step)]))} "上一步"])

       (when (and product-custom (< current-step (dec (count step-froms))))
         [:> ant/Button {:style {:margin-right 15}
                         :type "primary"
                         :on-click
                         (fn []
                           ((:validateFieldsAndScroll form)
                            (fn [err values]
                              (when (not err)
                                (let [data (js->clj values :keywordize-keys true)
                                      category-id (second (:category-ids data))]
                                  (rf/dispatch [:product/update-prodcut-detail data])
                                  (rf/dispatch [:product/set-current-step (inc current-step)]))))))} "下一步"])

       (when (or (not product-custom) (= current-step (dec (count step-froms))))
         [:> ant/Button {:style {:margin-right 15}
                         :type "primary"
                         :loading submit-loading
                         :on-click
                         (fn []
                           ((:validateFieldsAndScroll form)
                            (fn [err values]
                              (when (not err)
                                (rf/dispatch [:product/update
                                              (js->clj values :keywordize-keys true)])))))} "保存 "])])))

(defn one-col-item [title content]
  (let [props {:label title
               :style {:margin-left 10}
               :labelCol {:span 3}
               :wrapperCol {:span 18}}]
    [:> ant/Row
     [:> ant/Col {:span 18}
      [:> FormItem props
       content]]]))

(defn two-col-item []
  (defn two-item-props [title]
    {:label title :labelCol {:span 6} :wrapperCol {:span 18}})
  (fn []
    (let [this (r/current-component)
          children (r/children this)]
      [:> ant/Row
       [:> ant/Col {:span 10}
        [:> FormItem (two-item-props (get children 0))
         (get children 1)]]
       [:> ant/Col {:span 10}
        [:> FormItem (two-item-props (get children 2))
         (get children 3)]]])))

(defn three-col-item []
  (defn three-item-props [title]
    {:style {:margin-left 10}
     :label title
     :labelCol {:span 7}
     :wrapperCol {:span 15}})
  (fn []
    (let [this (r/current-component)
          children (r/children this)]
      [:> ant/Row
       [:> ant/Col {:span 8}
        [:> FormItem (three-item-props (get children 0))
         (get children 1)]]
       [:> ant/Col {:span 8}
        [:> FormItem (three-item-props (get children 2))
         (get children 3)]]
       [:> ant/Col {:span 8}
        [:> FormItem (three-item-props (get children 4))
         (get children 5)]]])))
