(ns <<project-ns>>.system.sys-user-events
  (:require
   [ajax.core :as http]
   [kee-frame.core :as kf]
   [re-frame.core :as rf]))

(def user-list-url "http://apiman.3vyd.com/mock/68/admin/sys/user/list")

(def default-query {:page 0 :size 10})

(kf/reg-controller
 :system-user/user-list-controller
 {:params (fn [route]
            (when (-> route :path-params :path (= "/system/user")) true))
  :start (fn [] [:system-user/user-table-load {}])})

(kf/reg-chain
 :system-user/user-table-load
 (fn [{:keys [db]} [query]]
   {:db (assoc-in db [:system-user :user-table :loading] true)
    :http-xhrio {:method :get
                 :uri user-list-url
                 :params (merge default-query (or query default-query))
                 :timeout 100000
                 :response-format (http/json-response-format  {:keywords? true})
                 :on-failure [:core/message-error]}})

 (fn [{:keys [db]} [_ {:keys [data]}]]
   {:db
    (assoc-in
     db
     [:system-user :user-table]
     {:data (:list data)
      :pagination (select-keys data [:page :size :total])
      :loading false})}))

(def default-user-form
  {:visible false
   :data {}
   :loading false})

(rf/reg-event-db
 :system-user/user-form-close
 (fn [db [_ _]]
   (assoc-in
    db
    [:system-user :user-form] default-user-form)))

(rf/reg-event-db
 :system-user/user-form-open
 (fn [db [_ data]]
   (assoc-in
    db
    [:system-user :user-form :visible] true)))


(rf/reg-event-db
 :system-user/password-form-open
 (fn [db [_ data]]
   (assoc-in
    db
    [:system-user :password-form] {:visible true :data data})))

(rf/reg-event-db
 :system-user/password-form-close
 (fn [db [_ data]]
   (assoc-in
    db
    [:system-user :password-form] {:visible false :data {}})))
